local class = require("core.class")
local state = require("ai.state")
local DL = require("design.DesignerLibrary")
local Passive = class.Class("Passive_Base", state.State)
function Passive:init()
  self.passiveTargetParams = self.passiveTargetParams or "FIND_TARGET_PARAMETERS_COMBAT_KRATOS_ONLY"
  self.goPlayerCreature = game.Player.FindPlayer()
  self.sixthSenseDistance = self.sixthSenseDistance or 0.7
  self.awarenessReceiveRange = self.awarenessReceiveRange or 30
  self.hitsTakenUntilAggro = self.hitsTakenUntilAggro or 1
end
function Passive:Enter(ai, global, constants)
  print("Running Passive:Enter from a " .. self.CLASSNAME)
  self.hitCounter = 0
end
function Passive:Update(ai, global, constants)
  ai:SetCombatTarget(global.target)
  global.target = ai:FindTarget(self.passiveTargetParams)
  if game.AIUtil.Distance(self.goPlayerCreature, ai) < self.sixthSenseDistance then
    DL.DebugPrint(ai, "Target is right behind me!")
    DL.SendAggroEvent(self.goPlayerCreature, ai)
    DL.BroadcastAggro(ai, global, constants)
    global.aggroState = "INCOMBAT"
  end
end
function Passive.Events:OnHitReaction(event, ai, global, constants)
  if self:IsActive() then
    self.hitCounter = self.hitCounter + 1
    if self.hitCounter >= self.hitsTakenUntilAggro then
      DL.DebugPrint(ai, "I was hit while PASSIVE!")
      ai:SetNavBank(global.navBank)
      DL.BroadcastAggro(ai, global, constants)
      global.aggroState = "INAGGRO"
    end
  end
end
function Passive.Events:OnBroadcastReaction(event, ai, global, constants)
  local distanceFromBroadcastingObject = (event.source:GetWorldPosition() - ai:GetWorldPosition()):Length()
  if self:IsActive() and distanceFromBroadcastingObject < self.awarenessReceiveRange then
    DL.DebugPrint(ai, "Received broadcast... checking context..")
    if DL.CheckCreatureContext(event.broadcastContext, "GRUNT_CRY") then
      DL.DebugPrint(ai, "Received GRUNT_CRY broadcast")
      global.aggroState = "INAGGRO"
    end
    return true
  end
end
function Passive:Exit(ai, global, constants)
  self.hitCounter = 0
end
return {Passive = Passive}
