local CLASSLIB = require("core.class")
local TIMER = require("level.timer")
local OneShotCamera = CLASSLIB.Class("OneShotCamera")
function OneShotCamera:init(cameraname, numseconds, properties)
  self.name = cameraname
  self.length = numseconds
  self.timer = TIMER.StartLevelTimer(self.length)
  self.timer:Stop()
  self.callback = nil
  if properties == nil then
    self.camera = game.Camera.StartCamera(self.name)
  else
    self.camera = game.Camera.StartCamera(self.name, properties)
  end
end
function OneShotCamera:Reset()
  self.timer:Reset()
end
function OneShotCamera:Reinitialize(properties)
  self.timer:Reset()
  if properties ~= nil then
    self.camera = game.Camera.StartCamera(self.name, properties)
  elseif self.properties == nil then
    self.camera = game.Camera.StartCamera(self.name)
  else
    self.camera = game.Camera.StartCamera(self.name, self.properties)
  end
end
function OneShotCamera:ChangeCameraDuration(numseconds)
  if self.timer ~= nil then
    self.timer = nil
  end
  self.length = numseconds
  self.timer = TIMER.StartLevelTimer(self.length)
  self.timer:Stop()
end
function OneShotCamera:Start()
  self.timer:Start()
end
function OneShotCamera:Update()
  if self.camera ~= nil then
    if self.timer.running == true then
      game.Camera.SubmitCamera(self.camera)
    end
    if self.timer.fired == true then
      self:StopCamera()
    end
  end
end
function OneShotCamera:StopCamera()
  self.camera = nil
  if self.callback ~= nil then
    self.callback()
  end
end
function OneShotCamera:SetCallback(fp)
  self.callback = fp
end
function OneShotCamera:EnableButton(plyr, buttonconstant, bPreviouslyDisabled)
  if bPreviouslyDisabled ~= true then
    plyr.Pad:EnableGameButton(buttonconstant)
  end
end
function OneShotCamera:DisableButton(plyr, buttonconstant, timeinseconds)
  local player = plyr
  local duration = timeinseconds or self.length
  local bDisabled = player.Pad:IsGameButtonDisabled(buttonconstant)
  player.Pad:DisableGameButton(buttonconstant)
  TIMER.StartLevelTimer(duration, function()
    self:EnableButton(player, buttonconstant, bDisabled)
  end)
end
function OneShotCamera:ActivateCineLock(timeinseconds, maxspeed)
  local player = game.Player.FindPlayer()
  local duration = timeinseconds or self.length
  local playerspeed = maxspeed or 1.5
  self:DisableButton(player, tweaks.ePad.kPadCross, duration)
  self:DisableButton(player, tweaks.ePad.kPadL3, duration)
  self:DisableButton(player, tweaks.ePad.kPadDown, duration)
  self:ActivateSlowWalk(player, duration, playerspeed)
end
function OneShotCamera:ActivateSlowWalk(plyr, timeinseconds, maxspeed)
  local player = plyr or game.Player.FindPlayer()
  local duration = timeinseconds or self.length
  local playerspeed = maxspeed or 1.5
  player:SetMaxSpeedOverride(playerspeed)
  TIMER.StartLevelTimer(duration, function()
    self:ClearSlowWalk(player)
  end)
end
function OneShotCamera:ClearSlowWalk(plyr)
  plyr:ClearMaxSpeedOverride()
end
return {OneShotCamera = OneShotCamera}
