local profile = require("core.profile")
local UpdateEnemyAssistCombatNavCamera = function(strThreatLevel, enemyCount)
  local player = game.Player.FindPlayer()
  if 1 < enemyCount then
    game.Camera.SubmitCameraByName("CBT_Nav_Far_Assist")
    if _G.gVFSCombatSlowVertical.value == true and player:HasMarker("Attacking") then
      game.Camera.SubmitCameraByName("CBT_Nav_Far_Assist_VC")
    end
  else
    game.Camera.SubmitCameraByName("CBT_Nav_Near_Assist")
    if _G.gVFSCombatSlowVertical.value == true and player:HasMarker("Attacking") then
      game.Camera.SubmitCameraByName("CBT_Nav_Near_Assist_VC")
    end
  end
  local enemiesNearbyPlayer = player:FindEnemies(30)
  if strThreatLevel == "veryLarge" then
    game.Camera.SubmitCameraByName("CBT_Nav_Far_Assist_LargeCreature")
  elseif strThreatLevel == "giantSmall" then
    game.Camera.SubmitCameraByName("CBT_Nav_Far_Assist_LargeCreature")
  elseif strThreatLevel == "flyer" then
    for _, enemy in ipairs(enemiesNearbyPlayer) do
      if enemy:HasMarker("Flutter") then
        game.Camera.SubmitCameraByName("CBT_SuperClose_InAir")
      end
    end
  end
end
local TargetingPlayerCount = function(enemiesNearPlayer)
  local iTargetingPlayer = 0
  for _, thisPlayerEnemy in ipairs(enemiesNearPlayer) do
    local enemyTarget = thisPlayerEnemy:GetTargetCreature()
    if thisPlayerEnemy:HasMarker("ForceCombatCam") then
      iTargetingPlayer = iTargetingPlayer + 1
    elseif enemyTarget ~= nil and (enemyTarget:GetName() == "heroa00" or enemyTarget:GetName() == "son00") and thisPlayerEnemy:IsDead() ~= true then
      iTargetingPlayer = iTargetingPlayer + 1
    end
  end
  return iTargetingPlayer
end
local GetThreatLevel = function(enemiesNearPlayer)
  local iTotalLiveEnemies = 0
  local totalByCreatureType = {}
  for _, thisPlayerEnemy in ipairs(enemiesNearPlayer) do
    local strEnemyName = thisPlayerEnemy:GetName()
    local bEnemyIsDead = thisPlayerEnemy:IsDead()
    if bEnemyIsDead ~= true then
      totalByCreatureType[strEnemyName] = (totalByCreatureType[strEnemyName] or 0) + 1
      iTotalLiveEnemies = iTotalLiveEnemies + 1
    end
  end
  if totalByCreatureType.earthdragon00 ~= nil and 0 < totalByCreatureType.earthdragon00 then
    return "dragon"
  end
  if totalByCreatureType.troll00 ~= nil and 0 < totalByCreatureType.troll00 or totalByCreatureType.troll10 ~= nil and 0 < totalByCreatureType.troll10 or totalByCreatureType.troll20 ~= nil and 0 < totalByCreatureType.troll20 or totalByCreatureType.troll30 ~= nil and 0 < totalByCreatureType.troll30 or totalByCreatureType.golem00 ~= nil and 0 < totalByCreatureType.golem00 then
    return "veryLarge"
  end
  if totalByCreatureType.cyclops00 ~= nil and 0 < totalByCreatureType.cyclops00 then
    return "giantLarge"
  end
  if totalByCreatureType.jotunn10 ~= nil and 0 < totalByCreatureType.jotunn10 or totalByCreatureType.jotunn00 ~= nil and 0 < totalByCreatureType.jotunn00 or totalByCreatureType.jotunn20 ~= nil and 0 < totalByCreatureType.jotunn20 then
    return "giantSmall"
  end
  if totalByCreatureType.darkone00 ~= nil and 0 < totalByCreatureType.darkone00 or totalByCreatureType.darkoneelite00 ~= nil and 0 < totalByCreatureType.darkoneelite00 then
    return "flyer"
  end
  if totalByCreatureType.wulver00 ~= nil and 0 < totalByCreatureType.wulver00 then
    return "wulver"
  end
  if 0 < iTotalLiveEnemies and iTotalLiveEnemies < 1 then
    return "groupSmall"
  end
  if 1 <= iTotalLiveEnemies and iTotalLiveEnemies < 8 then
    return "groupMedium"
  end
  if 8 <= iTotalLiveEnemies then
    return "groupLarge"
  end
  return "nothing"
end
return profile.WrapLibrary({
  UpdateEnemyAssistCombatNavCamera = UpdateEnemyAssistCombatNavCamera,
  TargetingPlayerCount = TargetingPlayerCount,
  GetThreatLevel = GetThreatLevel
})
