local CLASSLIB = require("core.class")
local EL = require("camera.EasingLibrary")
local TIMER = require("level.timer")
local CameraSequencer = CLASSLIB.Class("CameraSequencer")
function CameraSequencer:init(camera)
  self.camera = camera
  self.tActions = nil
  self.tDelays = nil
  self.numMoves = 0
  self.tPlaylist = nil
  self.tTimers = nil
  self.numMovesPlayed = 0
  self.bPlayedAllCameraMoves = false
  self.tBehaviors = nil
  self.numCameraMoves = 0
  self.numCameraMovesCompleted = 0
  self.tCameraMoves = nil
  self.tNameOfCameraMoves = nil
  self.bReady = false
end
function CameraSequencer:PrepareEaseTable(movetable, duration)
  local adjustmenttable = {}
  EL.SetupEaseTable(adjustmenttable)
  for attribute, value in pairs(movetable) do
    EL.SetBlendValue(self.camera, adjustmenttable, attribute, value)
  end
  EL.SetDuration(adjustmenttable, duration)
  EL.SetProgress(adjustmenttable, false)
  return adjustmenttable
end
function CameraSequencer:CreateTablesIfNecessary(adjustment, behavior, delay)
  if self.tActions == nil then
    self.tActions = {}
  end
  if self.tCameraMoves == nil and adjustment ~= nil then
    self.tCameraMoves = {}
  end
  if self.tNameOfCameraMoves == nil and adjustment ~= nil then
    self.tNameOfCameraMoves = {}
  end
  if self.tBehaviors == nil and behavior ~= nil then
    self.tBehaviors = {}
  end
  if 0 < delay then
    if self.tDelays == nil then
      self.tDelays = {}
    end
    if self.tTimers == nil then
      self.tTimers = {}
    end
  end
end
function CameraSequencer:AddToSequence(action, duration, delay, actionname, behaviortable)
  assert(action, "::AddToSequence() failed. Action does not exist")
  self.numMoves = self.numMoves + 1
  local cameraadjustment = action.Adjustment
  local camerabehavior = action.Effect
  self:CreateTablesIfNecessary(cameraadjustment, camerabehavior, delay)
  self.tActions[self.numMoves] = action
  self.tDelays[self.numMoves] = delay
  if cameraadjustment ~= nil then
    self.numCameraMoves = self.numCameraMoves + 1
    self.tCameraMoves[self.numMoves] = self:PrepareEaseTable(cameraadjustment, duration)
    self.tNameOfCameraMoves[self.numMoves] = actionname
  end
  if camerabehavior ~= nil then
    self.tBehaviors[self.numMoves] = camerabehavior
  end
end
function CameraSequencer:AddActionToPlaylist(actionindex)
  self.numMovesPlayed = self.numMovesPlayed + 1
  if self.tPlaylist == nil then
    self.tPlaylist = {}
  end
  if self.tCameraMoves ~= nil then
    local move = self.tCameraMoves[actionindex]
    if move ~= nil then
      EL.SetStartValue(self.camera, move)
      self.tPlaylist[actionindex] = move
      EL.SetProgress(move, true)
    end
  end
  if self.tBehaviors ~= nil then
    local behavior = self.tBehaviors[actionindex]
    if behavior ~= nil then
      game.FX.SubmitEffect(behavior)
    end
  end
end
function CameraSequencer:ScanAndPrepareSequence(camera)
  for actionindex, _ in pairs(self.tActions) do
    local delaytime = self.tDelays[actionindex]
    if 0 < delaytime then
      self.tTimers[actionindex] = TIMER.StartLevelTimer(delaytime, function()
        self:AddActionToPlaylist(actionindex)
      end)
    else
      self:AddActionToPlaylist(actionindex)
    end
  end
end
function CameraSequencer:Start(camera)
  self:ScanAndPrepareSequence(camera)
end
function CameraSequencer:Update(level, camera)
  if self.bPlayedAllCameraMoves == true then
    return
  end
  if self.tPlaylist == nil then
    return
  end
  local bCompleted
  for _, move in pairs(self.tPlaylist) do
    if EL.GetProgress(move) == true then
      bCompleted = EL.EaseEverything(level, move, self.camera, "InAndOut", "Quad")
      if bCompleted == true then
        self.numCameraMovesCompleted = self.numCameraMovesCompleted + 1
        if self.numCameraMovesCompleted >= self.numCameraMoves then
          self.bPlayedAllCameraMoves = true
        end
      end
    end
  end
end
function CameraSequencer:GetNameOfAttributeInMoveTable(table)
  for k, v in pairs(table) do
    if EL.IsValidCameraAttribute(k) and v.name ~= nil then
      return v.name
    end
  end
  return nil
end
return {CameraSequencer = CameraSequencer}
