local isTargetInFrustumUnobstructed = function(position, horizontalP, verticalP, penDepth, HudToggle)
  local player = game.Player.FindPlayer()
  local source = game.Camera.GetOrbitPosition()
  local markerCamPenetrate = game.Camera.GetViewPenetration(position, horizontalP, verticalP)
  if HudToggle == true then
    game.Camera.DrawPenetrationContour(horizontalP, verticalP, 1 - penDepth, 16711680)
  end
  if penDepth < markerCamPenetrate then
    local hit = game.World.RaycastCollision(source, position, {
      SourceGameObject = player,
      RejectMaterialFlags = game.GroundType.New("kGT_NoTargetThru"),
      CollidesWith = -1
    })
    if hit then
      return false
    else
      if HudToggle == true then
        engine.DrawLine(source, position, 16777215)
      end
      return true
    end
  end
end
local isTargetInFrustum = function(position, horizontalP, verticalP, penDepth, HudToggle)
  local markerCamPenetrate = game.Camera.GetViewPenetration(position, horizontalP, verticalP)
  if HudToggle == true then
    game.Camera.DrawPenetrationContour(horizontalP, verticalP, 1 - penDepth, 16777215)
  end
  if penDepth < markerCamPenetrate then
    return true
  end
end
return {isTargetInFrustumUnobstructed = isTargetInFrustumUnobstructed, isTargetInFrustum = isTargetInFrustum}
