local CLASSLIB = require("core.class")
local TIMER = require("level.timer")
local CineEnterCamera = CLASSLIB.Class("CineEnterCamera")
function CineEnterCamera:init(cameraname, numseconds, recentertable)
  self.cameraName = cameraname
  self.camTimeInSeconds = numseconds
  self.cineObj = nil
  self.callback = nil
  if recentertable == nil then
    print("No camera recenter specified")
  else
    self.tRecenter = recentertable
  end
  self.timer = TIMER.StartLevelTimer(self.camTimeInSeconds)
  self.timer:Stop()
  self.bStartedNavToPoint = false
end
function CineEnterCamera:SetObjectToSleep(obj)
  self.cineObj = obj
  if self.cineObj ~= nil then
    game.SubObject.Sleep(self.cineObj)
  end
end
function CineEnterCamera:Start()
  if self.cineObj ~= nil then
    game.SubObject.Wake(self.cineObj)
  end
  self.bStartedNavToPoint = true
end
function CineEnterCamera:Update()
  if self.bStartedNavToPoint == true and self.timer.running == false and self.timer.fired == false then
    self.timer:Start()
    if self.tRecenter ~= nil then
      game.Camera.Recenter(self.tRecenter)
    end
    self.bStartedNavToPoint = false
  end
  if self.timer.running == true and self.timer.fired == false then
    game.Camera.SubmitCameraByName(self.cameraName)
  end
  if self.timer.fired == true then
    if self.callback ~= nil then
      self.callback()
    end
    if self.cineObj ~= nil then
      game.SubObject.Sleep(self.cineObj)
    end
  end
end
function CineEnterCamera:SetCallback(fp)
  self.callback = fp
end
return {CineEnterCamera = CineEnterCamera}
