local class = require("core.class")
local BossState = class.Class("BossState")
function BossState:init(name, savepoint)
  self.stateName = name
  self.savepoint = savepoint or false
end
function BossState:Enter(level, skipSave)
  if self.OnEnter ~= nil then
    self.OnEnter(self, level, skipSave)
  end
  if self.savepoint and not skipSave then
    game.EvaluateLoadZones()
    game.World.StoreCheckpoint()
  end
end
function BossState:Exit(level)
  if self.OnExit ~= nil then
    self.OnExit(self, level)
  end
end
function BossState:Update(level)
  if self.OnUpdate ~= nil then
    self.OnUpdate(self, level)
  end
end
function BossState:GetStateName()
  return self.stateName
end
function BossState:SetupOnEnter(fn)
  assert(type(fn) == "function", "onEnter is not a function")
  self.OnEnter = fn
end
function BossState:SetupOnExit(fn)
  assert(type(fn) == "function", "OnExit is not a function")
  self.OnExit = fn
end
function BossState:SetupOnUpdate(fn)
  assert(type(fn) == "function", "OnUpdate is not a function")
  self.OnUpdate = fn
end
return BossState
