local classlib = require("core.class")
local WEAK_MT = {__mode = "kv"}
local make_table = function(weak)
  if weak then
    return setmetatable({}, WEAK_MT)
  else
    return {}
  end
end
local RunList = classlib.Class("RunList")
function RunList:init(weak)
  self.references = make_table(weak)
  self.updateList = make_table(weak)
end
function RunList:add(T)
  self.references[T] = true
end
function RunList:remove(T)
  self.references[T] = nil
end
function RunList:Update(...)
  local updateList = self.updateList
  for k in pairs(updateList) do
    updateList[k] = nil
  end
  do
    local i = 1
    for T in pairs(self.references) do
      updateList[i] = T
      i = i + 1
    end
  end
  for i, T in pairs(updateList) do
    updateList[i] = nil
    T:Update(...)
  end
end
return {RunList = RunList}
