local classlib = require("core.class")
local Stack = classlib.Class("Stack")
function Stack:init(...)
  self.stack = {}
  local stack = self.stack
  if (...) then
    for _, v in ipairs({
      ...
    }) do
      stack[#stack + 1] = v
    end
  end
end
function Stack:Push(value)
  self.stack[#self.stack + 1] = value
end
function Stack:Pop()
  local len = #self.stack
  local val
  if 0 < len then
    val = self.stack[len]
    self.stack[len] = nil
  end
  return val
end
function Stack:Top()
  return self.stack[#self.stack]
end
function Stack:Size()
  return #self.stack
end
return {Stack = Stack}
