local classlib = require("core.class")
local Stopwatch = classlib.Class("Stopwatch") .. {time = 0, running = false}
function Stopwatch:init(runList)
  assert(runList)
  self.runList = runList
end
function Stopwatch:Update(dt)
  if self.running then
    self.time = self.time + dt
  end
end
function Stopwatch:Start()
  self.running = true
  self.runlist:add(self)
end
function Stopwatch:Stop()
  self.running = false
  self.runlist:remove(self)
end
function Stopwatch:Restart()
  self:Reset()
  self:Start()
end
function Stopwatch:Reset()
  self:Stop()
  self.time = 0
  self.running = false
end
function Stopwatch:GetElapsedTime()
  return self.time
end
function Stopwatch:GetSecondsPart()
  return self.time % 60
end
function Stopwatch:GetMinutesPart()
  return math.floor(self.time / 60)
end
return {Stopwatch = Stopwatch}
