local IsEmpty = function(t)
  return nil == next(t)
end
local Clear = function(t)
  for k in pairs(t) do
    t[k] = nil
  end
end
local Index = function(t, x)
  for i, e in ipairs(t) do
    if e == x then
      return i
    end
  end
  return nil
end
local Contains = function(t, x)
  for _, v in pairs(t) do
    if v == x then
      return true
    end
  end
  return false
end
local Keys = function(t)
  local result = {}
  local i = 1
  for k in pairs(t) do
    result[i] = k
    i = i + 1
  end
  return result
end
local Values = function(t)
  local result = {}
  local i = 1
  for _, v in pairs(t) do
    result[i] = v
    i = i + 1
  end
  return result
end
local Length = function(T)
  local count = 0
  for _ in pairs(T) do
    count = count + 1
  end
  return count
end
local Reverse = function(l)
  local i, j = 1, #l
  while i < j do
    l[i], l[j] = l[j], l[i]
    i = i + 1
    j = j - 1
  end
end
local Inverse = function(t)
  local result = {}
  for k, v in pairs(t) do
    result[v] = k
  end
  return result
end
local SortedKeys = function(t)
  local keys = Keys(t)
  table.sort(keys)
  return keys
end
local SortedPairs = function(t)
  local keys = SortedKeys(t)
  local idx = 0
  local sorted_pairs_iter = function(s)
    idx = idx + 1
    local k = keys[idx]
    if not k then
      return nil
    end
    local v = s[k]
    return k, v
  end
  local f, s, var = sorted_pairs_iter, t
  return f, s, var
end
local Table = function(t)
  local result = t
  if nil == t then
    result = {}
  elseif "table" ~= type(t) then
    result = {t}
  end
  return result
end
local ListsEqual = function(l1, l2)
  local length = #l1
  if length ~= #l2 then
    return false
  end
  if 0 < length then
    for i = 1, length do
      if l1[i] ~= l2[i] then
        return false
      end
    end
  end
  return true
end
local FastInsert = function(list, item, index)
  assert(0 < index)
  assert(index <= 1 + #list)
  list[1 + #list] = list[index]
  list[index] = item
end
local FastRemove = function(list, index)
  assert(0 < index)
  assert(index <= 1 + #list)
  list[index] = list[1 + #list]
  list[1 + #list] = nil
end
return {
  Clear = Clear,
  IsEmpty = IsEmpty,
  Index = Index,
  Contains = Contains,
  Keys = Keys,
  Length = Length,
  Values = Values,
  Reverse = Reverse,
  Inverse = Inverse,
  SortedKeys = SortedKeys,
  SortedPairs = SortedPairs,
  Table = Table,
  ListsEqual = ListsEqual,
  FastInsert = FastInsert,
  FastRemove = FastRemove
}
