local thunk_list = {}
local ProfileCall = engine.ProfileCall
local InstallHook = function(hookName)
  if not _G.__hook_thunks[hookName] then
    local thunkName = string.format("[thunk] %s", hookName)
    local list = {}
    thunk_list[hookName] = list
    _G.__hook_thunks[hookName] = function(...)
      for _, fn in ipairs(list) do
        ProfileCall(thunkName, fn, ...)
      end
      local realHook = _G[hookName]
      if realHook then
        ProfileCall(hookName, realHook, ...)
      end
    end
  end
end
local Install = function(hookName, newFn)
  assert(type(newFn) == "function", "Trying to install a hook that is not a function!")
  InstallHook(hookName)
  table.insert(thunk_list[hookName], newFn)
end
return {Install = Install}
