local tablex = require("core.tablex")
local __FILE__ = function()
  return debug.getinfo(2, "S").source
end
local __LINE__ = function()
  return debug.getinfo(2, "l").currentline
end
local MaxLuaInt = 16777216
local AllocId = function(self)
  local id = self.nextFree
  while true do
    if nil == self[id] then
      self[id] = true
      break
    end
    id = id + 1
  end
  self.nextFree = id + 1
  return id
end
local DeallocId = function(self, id)
  assert(nil ~= self[id])
  self[id] = nil
  if id < self.nextFree then
    self.nextFree = id
  end
end
local CreateIdGen = function(table)
  if nil == table then
    table = {}
  else
    tablex.Clear(table)
  end
  table.nextFree = 0
  table.AllocId = AllocId
  table.DeallocId = DeallocId
  return table
end
return {
  __FILE__ = __FILE__,
  __LINE__ = __LINE__,
  MaxLuaInt = MaxLuaInt,
  CreateIdGen = CreateIdGen
}
