local class = require("core.class")
local creaturemonitor = require("creature.creaturemonitor")
local PickupMonitor = class.Class("PickupMonitor", creaturemonitor.CreatureMonitor)
local callPickupOrRelinquish
function PickupMonitor:OnAcquired(fn, ...)
  self:OnValue(true, callPickupOrRelinquish, self, fn, ...)
end
function PickupMonitor:OnRelinquished(fn, ...)
  self:OnValue(false, callPickupOrRelinquish, self, fn, ...)
end
local AddPickupMonitor = function(creature, pickupName)
  return PickupMonitor.New(creature, pickupName)
end
function callPickupOrRelinquish(value, self, fn, ...)
  print("Pickup Monitor triggered: '" .. tostring(self.creature) .. "' pickup '" .. self.pickupName .. "': " .. tostring(value))
  fn(self, self.creature, self.pickupName, ...)
end
function PickupMonitor:init(creature, pickupName)
  self.creature = creature
  self.pickupName = pickupName
  self.value = false
  self:Watch(self.watch_callback, self)
  self:Start()
end
function PickupMonitor:watch_callback()
  if self.creature == nil then
    return self.value
  end
  return self.creature:PickupIsAcquired(self.pickupName) or false
end
_G.AddPickupMonitor = AddPickupMonitor
return {PickupMonitor = PickupMonitor, Add = AddPickupMonitor}
