local DL = require("design.DesignerLibrary")
local Initialize = function(ai)
end
function LuaHook_WalkStartBranches(ai, branch)
  local locomotionInfo = ai:GetLocomotionInfo()
  if locomotionInfo.TargetSpeed <= 0.1 then
    return
  end
  local pathAngle
  local combatTarget = ai:GetTargetCreature()
  if ai.OwnedPOI ~= nil then
    pathAngle = DL.GetAngleBetweenVector(ai:GetWorldForward(), DL.ReturnFacing(ai.OwnedPOI))
  elseif combatTarget ~= nil then
    pathAngle = DL.FrontAngle(ai, combatTarget)
  elseif combatTarget == nil then
    pathAngle = locomotionInfo.PathAngle
  end
  if -45 < pathAngle and pathAngle < 45 then
    return branch:FindOutcomeBranchesEntry("MOV_WalkStart0")
  elseif 45 <= pathAngle and pathAngle <= 180 then
    return branch:FindOutcomeBranchesEntry("MOV_WalkStart120R")
  elseif pathAngle <= -45 and -180 <= pathAngle then
    return branch:FindOutcomeBranchesEntry("MOV_WalkStart120L")
  end
end
function LuaHook_WalkStopBranches(ai, branch)
  local locomotionInfo = ai:GetLocomotionInfo()
  if locomotionInfo.TargetSpeed > 0 then
    return nil
  end
  local angle, rightfoot
  local combatTarget = ai:GetTargetCreature()
  if ai.OwnedPOI ~= nil then
    angle = DL.GetAngleBetweenVector(ai:GetWorldForward(), DL.ReturnFacing(ai.OwnedPOI))
  elseif combatTarget ~= nil then
    angle = DL.FrontAngle(ai, combatTarget)
  elseif combatTarget == nil then
    angle = locomotionInfo.FocusAngle or ai:GetWorldForward()
  end
  local stopnow = false
  local rightFootPhase = locomotionInfo.RightFootPhase
  local leftFootPhase = locomotionInfo.LeftFootPhase
  if 0.27 < rightFootPhase and rightFootPhase < 0.47 then
    rightfoot = true
    stopnow = true
  elseif 0.27 < leftFootPhase and leftFootPhase < 0.4 then
    rightfoot = false
    stopnow = true
  end
  if stopnow then
    if angle < -45 then
      if rightfoot then
        return branch:FindOutcomeBranchesEntry("MOV_WalkStop120L_RFoot")
      else
        return branch:FindOutcomeBranchesEntry("MOV_WalkStop120L_LFoot")
      end
    elseif 45 < angle then
      if rightfoot then
        return branch:FindOutcomeBranchesEntry("MOV_WalkStop120R_RFoot")
      else
        return branch:FindOutcomeBranchesEntry("MOV_WalkStop120R_LFoot")
      end
    elseif rightfoot then
      return branch:FindOutcomeBranchesEntry("MOV_WalkStop0_RFoot")
    else
      return branch:FindOutcomeBranchesEntry("MOV_WalkStop0_LFoot")
    end
  end
end
function LuaHook_PlantTurnBranches(ai, branch)
  local locomotionInfo = ai:GetLocomotionInfo()
  local pathAngle = locomotionInfo.PathAngle
  if pathAngle == nil then
    return
  end
  if pathAngle <= -60 then
    return branch:FindOutcomeBranchesEntry("MOV_WalkPlantTurn120L")
  elseif 60 <= pathAngle then
    return branch:FindOutcomeBranchesEntry("MOV_WalkPlantTurn120R")
  end
end
function LuaHook_IdleTurnInPlace(ai, branch)
  local combatTarget = ai:GetTargetCreature()
  if combatTarget ~= nil and ai.OwnedPOI == nil then
    local desiredDirectionDelta = DL.FrontAngleFromPoint(ai, combatTarget.WorldPosition)
    if desiredDirectionDelta ~= nil then
      if -90 <= desiredDirectionDelta and desiredDirectionDelta <= -80 then
        return branch:FindOutcomeBranchesEntry("MOV_TurnOnSpot90L")
      elseif 60 < desiredDirectionDelta and desiredDirectionDelta <= 80 then
        return branch:FindOutcomeBranchesEntry("MOV_TurnOnSpot90R")
      elseif desiredDirectionDelta < -90 then
        return branch:FindOutcomeBranchesEntry("MOV_TurnOnSpot180L")
      elseif 80 < desiredDirectionDelta then
        return branch:FindOutcomeBranchesEntry("MOV_TurnOnSpot180R")
      end
    end
  end
end
function LuaHook_IdleTurnInPlaceContinue(ai, branch)
  local combatTarget = ai:GetTargetCreature()
  if combatTarget ~= nil and ai.OwnedPOI == nil then
    local desiredDirectionDelta = DL.FrontAngleFromPoint(ai, combatTarget.WorldPosition)
    if desiredDirectionDelta ~= nil then
      if desiredDirectionDelta < -55 then
        return branch:FindOutcomeBranchesEntry("MOV_TurnOnSpot180L")
      elseif 55 < desiredDirectionDelta then
        return branch:FindOutcomeBranchesEntry("MOV_TurnOnSpot180R")
      end
    end
  end
end
local Install = function()
end
return {Install = Install, Initialize = Initialize}
