local DL = require("design.DesignerLibrary")
function LuaHook_WalkStartBranches(ai, branch)
  local locomotionInfo = ai:GetLocomotionInfo()
  local targetSpeed = locomotionInfo.TargetSpeed
  local pathAngle = locomotionInfo.PathAngle
  if pathAngle == nil or targetSpeed <= 0.1 then
    return
  end
  if -20 < pathAngle and pathAngle < 20 then
    return branch:FindOutcomeBranchesEntry("MOV_WalkStart0")
  elseif 20 <= pathAngle and pathAngle <= 180 then
    return branch:FindOutcomeBranchesEntry("MOV_WalkStart120R")
  elseif pathAngle <= -20 and -180 <= pathAngle then
    return branch:FindOutcomeBranchesEntry("MOV_WalkStart120L")
  end
end
function LuaHook_WalkStopBranches(ai, branch)
  local locomotionInfo = ai:GetLocomotionInfo()
  if locomotionInfo.TargetSpeed > 0 then
    return nil
  end
  local angle = 0
  local combatTarget = ai:GetTargetCreature()
  if ai.OwnedPOI ~= nil then
    angle = DL.GetAngleBetweenVector(ai:GetWorldForward(), DL.ReturnFacing(ai.OwnedPOI))
  elseif combatTarget ~= nil then
    angle = DL.FrontAngle(ai, combatTarget)
  end
  if angle < -20 then
    return branch:FindOutcomeBranchesEntry("MOV_WalkStop120L")
  elseif 20 < angle then
    return branch:FindOutcomeBranchesEntry("MOV_WalkStop120R")
  else
    return branch:FindOutcomeBranchesEntry("MOV_WalkStop0")
  end
end
function LuaHook_PlantTurnBranches(ai, branch)
  local locomotionInfo = ai:GetLocomotionInfo()
  local pathAngle = locomotionInfo.PathAngle
  if pathAngle == nil then
    return
  end
  if pathAngle <= -85 and -180 < pathAngle then
    return branch:FindOutcomeBranchesEntry("MOV_WalkPlantTurn120L")
  elseif pathAngle < 180 and 85 <= pathAngle then
    return branch:FindOutcomeBranchesEntry("MOV_WalkPlantTurn120R")
  end
end
function LuaHook_IdleTurnInPlace(ai, branch)
  local combatTarget = ai:GetTargetCreature()
  if combatTarget ~= nil and ai.OwnedPOI == nil then
    local desiredDirectionDelta = DL.FrontAngleFromPoint(ai, combatTarget.WorldPosition)
    if desiredDirectionDelta ~= nil then
      if -100 <= desiredDirectionDelta and desiredDirectionDelta <= -80 then
        return branch:FindOutcomeBranchesEntry("MOV_StandTurn90L")
      elseif 50 < desiredDirectionDelta and desiredDirectionDelta <= 100 then
        return branch:FindOutcomeBranchesEntry("MOV_StandTurn90R")
      elseif desiredDirectionDelta < -100 and -180 <= desiredDirectionDelta then
        return branch:FindOutcomeBranchesEntry("MOV_StandTurn180L")
      elseif desiredDirectionDelta < 180 and 100 < desiredDirectionDelta then
        return branch:FindOutcomeBranchesEntry("MOV_StandTurn180R")
      end
    end
  end
end
function LuaHook_IdleTurnInPlaceCrawler(ai, branch)
  local combatTarget = ai:GetTargetCreature()
  if combatTarget ~= nil and ai.OwnedPOI == nil then
    local desiredDirectionDelta = DL.FrontAngleFromPoint(ai, combatTarget.WorldPosition)
    if desiredDirectionDelta ~= nil then
      if -100 <= desiredDirectionDelta and desiredDirectionDelta <= -50 then
        return branch:FindOutcomeBranchesEntry("MOV_StandTurn90L")
      elseif 50 < desiredDirectionDelta and desiredDirectionDelta <= 100 then
        return branch:FindOutcomeBranchesEntry("MOV_StandTurn90R")
      elseif desiredDirectionDelta < -100 and -180 <= desiredDirectionDelta then
        return branch:FindOutcomeBranchesEntry("MOV_StandTurn180L")
      elseif desiredDirectionDelta < 180 and 100 < desiredDirectionDelta then
        return branch:FindOutcomeBranchesEntry("MOV_StandTurn180R")
      end
    end
  end
end
local Install = function()
end
return {Install = Install}
