local locationDriver, directionDriver, locationEdgeDriver, directionEdgeDriver
local OnUpdate = function(crt)
  if not locationDriver then
    locationDriver = crt:GetAnimDriver("TraverseLinkLocation")
  end
  if not directionDriver then
    directionDriver = crt:GetAnimDriver("TraverseLinkDirection")
  end
  if not locationEdgeDriver then
    locationEdgeDriver = crt:GetAnimDriver("TraverseLinkEdgeLocation")
  end
  if not directionEdgeDriver then
    directionEdgeDriver = crt:GetAnimDriver("TraverseLinkEdgeDirection")
  end
end
local LuaHook_TraverseLink = function(crt)
  local traverseLink = crt:GetTraverseLink()
  if traverseLink and locationDriver and directionDriver then
    locationDriver.ValueVec = traverseLink.WarpLocation
    directionDriver.ValueVec = traverseLink.WarpDirection
    locationEdgeDriver.ValueVec = traverseLink.WarpEdgeLocation
    directionEdgeDriver.ValueVec = traverseLink.WarpEdgeDirection
  end
end
local InstallHooks = function()
  _G.LuaHook_TraverseLink = LuaHook_TraverseLink
end
return {OnUpdate = OnUpdate, InstallHooks = InstallHooks}
