local profile = require("core.profile")
local GiveSkillTreeRecipes = function(recipesByTierTable)
  for resourceTierLock, recipes in pairs(recipesByTierTable) do
    if game.Wallets.HasResource("HERO", resourceTierLock) then
      for _, recipe in pairs(recipes) do
        if not game.Wallets.HasRecipe("HERO", recipe) then
          game.Wallets.AddRecipe("HERO", recipe)
        else
          engine.Warning("Skill-tree recipe " .. recipe .. " was acquired before Arrow unlock. How was it originally granted?")
        end
      end
    end
  end
end
local GiveLightArrow = function()
  local son = game.AI.FindSon()
  if not game.Wallets.HasResource("HERO", "ArrowUnlock_Light") then
    game.Wallets.AddResource("HERO", "ArrowUnlock_Light", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_SonPerk_LightArrow_WeakenDefense")
    if son ~= nil and not son:PickupIsAcquired("SonArrow_Light") then
      son:PickupAcquire("SonArrow_Light")
    end
    local lightRecipesByTier = {
      ReinforcementBow_Tier02 = {
        "Recipe_SonPerk_LightArrow_Potency_Tier01"
      },
      ReinforcementBow_Tier03 = {
        "Recipe_SonPerk_LightArrow_Potency_Tier02",
        "Recipe_SonPerk_LightArrow_ExplosionRadius"
      },
      ReinforcementBow_Tier04 = {
        "Recipe_SonPerk_LightArrow_Potency_Tier03"
      },
      ReinforcementBow_Tier05 = {
        "Recipe_SonPerk_LightArrow_ExplosionSpread"
      }
    }
    GiveSkillTreeRecipes(lightRecipesByTier)
  else
    local lightResourceCount = game.Wallets.GetResourceValue("HERO", "ArrowUnlock_Light")
    if lightResourceCount == 0 then
      game.Wallets.AddResource("HERO", "ArrowUnlock_Light", 1, "NO_TELEMETRY")
    end
    if son ~= nil and not son:PickupIsAcquired("SonArrow_Light") then
      son:PickupAcquire("SonArrow_Light")
    end
  end
end
local RemoveLightArrow = function()
  local son = game.AI.FindSon()
  if game.Wallets.HasResource("HERO", "ArrowUnlock_Light") and son ~= nil and not son:PickupIsAcquired("SonArrow_Regular") then
    son:PickupAcquire("SonArrow_Regular")
    game.Wallets.Craft("HERO", "SonLightArrow_Consume")
  end
end
local GiveShockArrow = function()
  local son = game.AI.FindSon()
  if not game.Wallets.HasResource("HERO", "ArrowUnlock_Shock") then
    game.Wallets.AddResource("HERO", "ArrowUnlock_Shock", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_SonPerk_ShockArrow_SparkRate")
    if son ~= nil and not son:PickupIsAcquired("SonArrow_Shock") then
      son:PickupAcquire("SonArrow_Shock")
    end
    local shockRecipesByTier = {
      ReinforcementBow_Tier02 = {
        "Recipe_SonPerk_ShockArrow_Potency_Tier01"
      },
      ReinforcementBow_Tier03 = {
        "Recipe_SonPerk_ShockArrow_Potency_Tier02",
        "Recipe_SonPerk_ShockArrow_DetonationConduit"
      },
      ReinforcementBow_Tier04 = {
        "Recipe_SonPerk_ShockArrow_Potency_Tier03"
      },
      ReinforcementBow_Tier05 = {
        "Recipe_SonPerk_ShockArrow_OnHitSpark"
      }
    }
    GiveSkillTreeRecipes(shockRecipesByTier)
  else
    local lightResourceCount = game.Wallets.GetResourceValue("HERO", "ArrowUnlock_Shock")
    if lightResourceCount == 0 then
      game.Wallets.AddResource("HERO", "ArrowUnlock_Shock", 1, "NO_TELEMETRY")
    end
    if son ~= nil and not son:PickupIsAcquired("SonArrow_Shock") then
      son:PickupAcquire("SonArrow_Shock")
    end
  end
end
local RemoveShockArrow = function()
  local son = game.AI.FindSon()
  if game.Wallets.HasResource("HERO", "ArrowUnlock_Shock") and son ~= nil and not son:PickupIsAcquired("SonArrow_Regular") then
    son:PickupAcquire("SonArrow_Regular")
    game.Wallets.Craft("HERO", "SonShockArrow_Consume")
  end
end
return profile.WrapLibrary({
  GiveLightArrow = GiveLightArrow,
  RemoveLightArrow = RemoveLightArrow,
  GiveShockArrow = GiveShockArrow,
  RemoveShockArrow = RemoveShockArrow
})
