local profile = require("core.profile")
local ForceAxeUnembed = function(collisionObject, callback)
  if collisionObject:IsAxeEmbedded() then
    game.Player.FindPlayer():DropThrowable("ATT_Axe")
    if callback then
      callback()
    end
  end
end
local PlayerSheathAxe = function(puppeteerObj, callback)
  local heroPuppeteer = game.Puppeteer.NewForce(puppeteerObj, "LDLib - Player Sheath Axe", game.Player.FindPlayer())
  if heroPuppeteer.WeaponEquip then
    heroPuppeteer:WeaponEquip({weaponMode = "Bare"})
  else
    heroPuppeteer:Weapon("Bare")
  end
  heroPuppeteer:OnComplete(function()
    heroPuppeteer:Clear()
    heroPuppeteer = nil
    if callback ~= nil and type(callback) == "function" then
      callback()
    end
  end)
end
local PlayerUnsheathAxe = function(puppeteerObj, callback)
  local heroPuppeteer = game.Puppeteer.NewForce(puppeteerObj, "LDLib - Player Unsheath Axe", game.Player.FindPlayer())
  if heroPuppeteer.WeaponRestore then
    heroPuppeteer:WeaponRestore()
  else
    heroPuppeteer:Weapon("Unsheath")
  end
  heroPuppeteer:OnComplete(function()
    heroPuppeteer:Clear()
    heroPuppeteer = nil
    if callback ~= nil and type(callback) == "function" then
      callback()
    end
  end)
end
return profile.WrapLibrary({
  ForceAxeUnembed = ForceAxeUnembed,
  PlayerSheathAxe = PlayerSheathAxe,
  PlayerUnsheathAxe = PlayerUnsheathAxe
})
