local profile = require("core.profile")
local EnableBoatLore = function(waitTime)
  game.Audio.EnableStoryTime(true)
  game.Audio.SetBanterFact("selected_lore", -1)
  if waitTime then
    game.Audio.SetBanterFact("boatBanterCooldown", true, waitTime)
  end
end
local DisableBoatLore = function()
  game.Audio.EnableStoryTime(false)
  game.Audio.SetBanterFact("selected_lore", -1)
end
local ResetSelectedLore = function(waitTime)
  game.Audio.SetBanterFact("selected_lore", -1)
  if waitTime then
    game.Audio.SetBanterFact("boatBanterCooldown", true, waitTime)
  end
end
local DisableBoatLoreWithoutStoryTime = function()
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("disableBoatLoreInWAD", true)
end
local EnableBoatLoreWithoutStoryTime = function(value, waitTime)
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("disableBoatLoreInWAD", false)
  if waitTime then
    game.Audio.SetBanterFact("boatBanterCooldown", true, waitTime)
  end
end
local UnlockPreMimirBoatLore = function()
  if not _G.StartLevelTimer then
    require("level.timer")
  end
  local preMimirIncrements = {
    "tortoise_increment",
    "horse_increment",
    "frog_increment",
    "thief_increment",
    "crab_increment",
    "trees_increment",
    "scorpion_increment",
    "port_increment",
    "portRemind_increment1",
    "portRemind_increment2",
    "momStrong_increment",
    "inWar_increment"
  }
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("preMimir_lore_unlocked", true)
  game.Audio.SetBanterFact("mimir_unlocked", false)
  game.Audio.SetBanterFact("preMimir_boat_lore_end", false)
  for i = 1, #preMimirIncrements do
    _G.StartLevelTimer(0.1 * i, function()
      game.Audio.SetBanterFact(preMimirIncrements[i], 0)
    end)
  end
end
local UnlockGoodFellowsBoatLore = function()
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("goodFellows_unlocked", true)
end
local UnlockHrimthursRevengeBoatLore = function()
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("hrimthur_unlocked", true)
end
local UnlockMagniModiBoatLore = function()
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("magniModi_unlocked", true)
end
local UnlockTyrOdinBoatLore = function()
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("tyrOdin_unlocked", true)
end
local UnlockWrapOnMimirBoatLore = function()
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("wrapOnMimir_unlocked", true)
end
local UnlockMimirBoatLore = function()
  local mimirIncrements = {
    "bergelmir_increment",
    "groa_increment",
    "hrung_increment",
    "skollanhati_increment",
    "skadi_increment",
    "starkadr_increment",
    "surtr_increment",
    "thrym_increment",
    "ymir_increment",
    "odinFreya1Increment",
    "odinFreya2Increment",
    "odinFreya3Increment",
    "tyrOdinIncrement",
    "magniModiIncrement",
    "goodFellowsIncrement",
    "onTheWellIncrement",
    "mimirOdinIncrement",
    "hrimthur_increment"
  }
  game.Audio.SetBanterFact("selected_lore", -1)
  game.Audio.SetBanterFact("mimir_unlocked", true)
  game.Audio.SetBanterFact("preMimir_boat_lore_end", true)
  for i = 1, #mimirIncrements do
    _G.StartLevelTimer(0.1 * i, function()
      game.Audio.SetBanterFact(mimirIncrements[i], 0)
    end)
  end
end
local questBanterOnBoatEnter = {}
local QUEST_TYPE = {STANDARD = 1, PROGRESSIVE = 2}
questBanterOnBoatEnter.Quest_UnfinishedBusiness02_Objective_01 = {
  questType = QUEST_TYPE.PROGRESSIVE,
  banterName = {
    "UB1DesMdn_1stBoneBoatBanter",
    "UB1DesMdn_2ndBoneBoatBanter"
  }
}
questBanterOnBoatEnter.Quest_UnfinishedBusiness02_Objective_02 = {
  questType = QUEST_TYPE.STANDARD,
  banterName = {
    "UB1DesMdn_BonePonderInterlude"
  }
}
questBanterOnBoatEnter.Quest_UnfinishedBusiness03_Objective_01 = {
  questType = QUEST_TYPE.STANDARD,
  banterName = {
    "UB_TR_QuestReminderConvo"
  }
}
questBanterOnBoatEnter.Quest_UnfinishedBusiness03_Return = {
  questType = QUEST_TYPE.STANDARD,
  banterName = {
    "UB_TR_QuestPonder"
  }
}
questBanterOnBoatEnter.Quest_UnfinishedBusiness04_Parent = {
  questType = QUEST_TYPE.STANDARD,
  banterName = {
    "UB4_DF_WeGonnaHelp"
  }
}
questBanterOnBoatEnter.Quest_UnfinishedBusiness04_Objective_01 = {
  questType = QUEST_TYPE.PROGRESSIVE,
  banterName = {
    "UB4_DF_LeavingFirstBeach ",
    "UB4_DF_LeavingSecondBeach "
  }
}
questBanterOnBoatEnter.Quest_UnfinishedBusiness04_Return = {
  questType = QUEST_TYPE.STANDARD,
  banterName = {
    "UB4_DF_OnTheWaytoCheckIn"
  }
}
questBanterOnBoatEnter.Quest_UnfinishedBusiness05_Objective_01 = {
  questType = QUEST_TYPE.PROGRESSIVE,
  banterName = {
    "XPL0_BoatBanter1",
    "XPL0_BoatBanter2",
    "XPL0_BoatBanter3"
  }
}
questBanterOnBoatEnter.Quest_Brothers_Epic_03_Objective_01 = {
  questType = QUEST_TYPE.STANDARD,
  banterName = {
    "HTTK_AlreadyBeenToStronghold"
  }
}
local questBanterIndexTable = {}
for key, _ in pairs(questBanterOnBoatEnter) do
  table.insert(questBanterIndexTable, key)
  engine.Print("Stored QuestName " .. tostring(key) .. " @ Index =  " .. tostring(#questBanterIndexTable))
end
table.sort(questBanterIndexTable)
for newIndex = 1, #questBanterIndexTable do
  questBanterOnBoatEnter[questBanterIndexTable[newIndex]].index = newIndex
  engine.Print("Added Index " .. tostring(newIndex) .. " @ QuestName " .. questBanterIndexTable[newIndex])
end
local SetRecentlyActivatedQuest = function(objectiveName)
  if questBanterOnBoatEnter[objectiveName] == nil then
    engine.Error("Error in BoatBanterLibrary.lua: QuestName " .. tostring(objectiveName) .. " does not exist in questBanterIndexTable")
    return
  end
  game.Level.SetVariable("QuestBanterIndex", questBanterOnBoatEnter[objectiveName].index)
  engine.Print("Print in BoatBanterLibrary.lua: QuestName " .. tostring(objectiveName) .. " is ready to play Banter OnBoatEnter. QuestBanterIndex = " .. tostring(questBanterOnBoatEnter[objectiveName].index))
end
local PlayQuestObjectBoatBanter = function()
  local objectiveName
  local index = game.Level.GetVariable("QuestBanterIndex")
  if questBanterIndexTable[index] == nil then
    game.Level.SetVariable("QuestBanterIndex", -1)
    engine.Warning("Warning in BoatBanterLibrary.lua: QuestBanter Index " .. tostring(index) .. " does not exist in questBanterIndexTable")
    return
  else
    objectiveName = questBanterIndexTable[index]
  end
  if questBanterOnBoatEnter[objectiveName] == nil then
    engine.Error("Error in BoatBanterLibrary.lua: QuestName " .. tostring(objectiveName) .. " does not exist in questBanterIndexTable")
    return
  end
  if game.QuestManager.GetQuestState(objectiveName) ~= "Active" then
    game.Level.SetVariable("QuestBanterIndex", -1)
    engine.Warning("Warning in BoatBanterLibrary.lua: QuestName " .. tostring(objectiveName) .. [[
 is not active. OnBoatEnter Quest Banter wont play. Resetting QuestBanterIndex.
Make sure LD.SetRecentlyActivatedQuest( questName ) was called previosuly]])
    return
  end
  if questBanterOnBoatEnter[objectiveName].questType == QUEST_TYPE.PROGRESSIVE then
    local _, progressCount = game.QuestManager.GetQuestProgressAndGoal(objectiveName)
    local questBanterToPlay = questBanterOnBoatEnter[objectiveName].banterName[progressCount]
    game.Audio.PlayBanterNonCritical(questBanterToPlay, nil, nil, true, function()
      game.Level.SetVariable("QuestBanterIndex", -1)
    end)
  elseif questBanterOnBoatEnter[objectiveName].questType == QUEST_TYPE.STANDARD then
    local questBanterToPlay = questBanterOnBoatEnter[objectiveName].banterName
    if type(questBanterToPlay) == "table" then
      questBanterToPlay = questBanterToPlay[1]
    end
    game.Audio.PlayBanterNonCritical(questBanterToPlay, nil, nil, true, function()
      game.Level.SetVariable("QuestBanterIndex", -1)
    end)
  else
    game.Level.SetVariable("QuestBanterIndex", -1)
    engine.Error("Error in BoatBanterLibrary.lua: Invalid or No questType defined for " .. tostring(objectiveName) .. " in questBanterIndexTable")
  end
end
local PlayEnterBoatBanter = function()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if game.Level.GetVariable("QuestBanterIndex") ~= -1 then
    PlayQuestObjectBoatBanter()
  end
  if 330 <= completedCineNum then
    game.Audio.SetBanterFact("selected_lore", -1)
    game.Audio.SetBanterFact("mimir_unlocked", true)
    game.Audio.SetBanterFact("preMimir_boat_lore_end", true)
  elseif 183 <= completedCineNum then
    game.Audio.SetBanterFact("selected_lore", -1)
    game.Audio.SetBanterFact("mimir_unlocked", false)
    game.Audio.SetBanterFact("preMimir_lore_unlocked", true)
  end
  local safeCinesForBoatLore = {
    {min = 183, max = 195},
    {min = 230, max = 320},
    {min = 350, max = 360},
    {min = 425, max = 999}
  }
  if game.Audio.XXX_ResetStoryTimeEnabled then
    for i = 1, #safeCinesForBoatLore do
      if completedCineNum >= safeCinesForBoatLore[i].min and completedCineNum <= safeCinesForBoatLore[i].max then
        game.Audio.XXX_ResetStoryTimeEnabled()
        return
      end
    end
  end
end
return profile.WrapLibrary({
  EnableBoatLore = EnableBoatLore,
  EnableBoatLoreWithoutStoryTime = EnableBoatLoreWithoutStoryTime,
  DisableBoatLore = DisableBoatLore,
  DisableBoatLoreWithoutStoryTime = DisableBoatLoreWithoutStoryTime,
  PlayEnterBoatBanter = PlayEnterBoatBanter,
  ResetSelectedLore = ResetSelectedLore,
  SetRecentlyActivatedQuest = SetRecentlyActivatedQuest,
  UnlockGoodFellowsBoatLore = UnlockGoodFellowsBoatLore,
  UnlockHrimthursRevengeBoatLore = UnlockHrimthursRevengeBoatLore,
  UnlockMagniModiBoatLore = UnlockMagniModiBoatLore,
  UnlockMimirBoatLore = UnlockMimirBoatLore,
  UnlockPreMimirBoatLore = UnlockPreMimirBoatLore,
  UnlockTyrOdinBoatLore = UnlockTyrOdinBoatLore,
  UnlockWrapOnMimirBoatLore = UnlockWrapOnMimirBoatLore
})
