local profile = require("core.profile")
local BreakObject = function(gameObject, args)
  for _, descendant in pairs(gameObject.Descendants) do
    if descendant:IsBreakable() then
      local brk = descendant:GetBreakable()
      if brk.Broken == false then
        brk:Break()
      end
    elseif game.CHECK_FEATURE("DYNAMICALLY_PARENTED_CHECKED") then
      if descendant:IsDescendantDynamicallyParentedTo(gameObject) == false and descendant.AnimFrame ~= nil then
        local rate = 1
        if args then
          rate = args.rate or 1
        end
        descendant:PlayAnimToEnd(rate)
      end
    elseif descendant.AnimFrame ~= nil then
      local rate = 1
      if args then
        rate = args.rate or 1
      end
      descendant:PlayAnimToEnd(rate)
    end
  end
end
local RemoveBreakable = function(go)
  if not go.Child or go.Child.Broken == nil then
    error("GameObject ", go, " is not a Breakable")
  end
  _G.StartLevelTimer(0.01, function()
    if not go.Child.Broken then
      go.Child:BreakAllStages()
    end
  end)
end
return profile.WrapLibrary({BreakObject = BreakObject, RemoveBreakable = RemoveBreakable})
