local classlib = require("core.class")
local Debuff_HeroFrostComponent = classlib.Class("Debuff_HeroFrostComponent")
function Debuff_HeroFrostComponent:init()
  self.isOn = false
end
function Debuff_HeroFrostComponent:IsAvailable(go)
  local retVal = false
  if go:PickupIsAcquired("Debuff_Hero_Frost") then
    retVal = true
  end
  return retVal
end
function Debuff_HeroFrostComponent:Enter(go)
  if go:PickupIsAcquired("Debuff_Hero_Burn") then
    go:PickupRelinquish("Debuff_Hero_Burn")
    go:MeterSetValue("Burn", 0)
  end
  if go:AttributeGetValue("Difficulty") == 4 then
    go:AddMarker("FrostActive")
  end
end
function Debuff_HeroFrostComponent:Exit(go)
  if go:HasMarker("FrostActive") then
    go:RemoveMarker("FrostActive")
  end
end
function Debuff_HeroFrostComponent:Update(go)
  if go:PickupIsAcquired("RageMode") and go:PickupGetStage("RageMode") == 1 then
    go:PickupRelinquish("Debuff_Hero_Frost")
  end
end
local Debuff_HeroFreezeComponent = classlib.Class("Debuff_HeroFreezeComponent")
function Debuff_HeroFreezeComponent:init()
  self.isOn = false
end
function Debuff_HeroFreezeComponent:IsAvailable(go)
  local retVal = false
  if go:PickupIsAcquired("Debuff_Hero_Freeze") then
    retVal = true
  end
  return retVal
end
function Debuff_HeroFreezeComponent:Enter(go)
  if go:PickupIsAcquired("Debuff_Hero_Burn") then
    go:PickupRelinquish("Debuff_Hero_Burn")
    go:MeterSetValue("Burn", 0)
  end
end
function Debuff_HeroFreezeComponent:Exit(go)
end
function Debuff_HeroFreezeComponent:Update(go)
  if go:PickupIsAcquired("RageMode") and go:PickupGetStage("RageMode") == 1 then
    go:PickupRelinquish("Debuff_Hero_Freeze")
  end
end
local Debuff_HeroBurnComponent = classlib.Class("Debuff_HeroBurnComponent")
function Debuff_HeroBurnComponent:init()
  self.isOn = false
  self.burnRumble = {
    EffectName = "FFB_SMALLER",
    Duration = 0.5
  }
end
function Debuff_HeroBurnComponent:IsAvailable(go)
  local retVal = false
  if go:PickupIsAcquired("Debuff_Hero_Burn") then
    retVal = true
  end
  return retVal
end
function Debuff_HeroBurnComponent:Enter(go)
  if go:PickupIsAcquired("Debuff_Hero_Frost") then
    go:PickupRelinquish("Debuff_Hero_Frost")
    go:MeterSetValue("Frost", 0)
  end
end
function Debuff_HeroBurnComponent:Exit(go)
end
function Debuff_HeroBurnComponent:Update(go)
  game.FX.SubmitEffect(self.burnRumble)
end
local Debuff_HeroPoisonComponent = classlib.Class("Debuff_HeroPoisonComponent")
function Debuff_HeroPoisonComponent:init()
  self.isOn = false
  self.poisonRumble = {
    EffectName = "FFB_SMALLER",
    Duration = 1
  }
end
function Debuff_HeroPoisonComponent:IsAvailable(go)
  local retVal = false
  if go:PickupIsAcquired("Debuff_Hero_Poison_Short") or go:PickupIsAcquired("Debuff_Hero_Poison_Persist") then
    retVal = true
  end
  return retVal
end
function Debuff_HeroPoisonComponent:Enter(go)
end
function Debuff_HeroPoisonComponent:Exit(go)
end
function Debuff_HeroPoisonComponent:Update(go)
  game.FX.SubmitEffect(self.poisonRumble)
end
local Debuff_HeroBlindComponent = classlib.Class("Debuff_HeroBlindComponent")
function Debuff_HeroBlindComponent:init()
  self.isOn = false
  self.heroStill = false
  self.heroStillTimer = 0
  self.heroMovementTimer = 0
  self.heroStillTimerLimit = 0.75
  self.heroMovementTimerLimit = 0.4
end
function Debuff_HeroBlindComponent:IsAvailable(go)
  local retVal = false
  if go:PickupIsAcquired("Debuff_Hero_Blind") or go:PickupIsAcquired("Debuff_Hero_Blind_Persist") then
    retVal = true
  end
  return retVal
end
function Debuff_HeroBlindComponent:Enter(go)
  game.Level.SetVariable("DEBUFF_Disable_Offscreen_Indicators", true)
  go:AddMarker("HideOffScreenIndicators")
  go:EnableLockOnSystem(0)
end
function Debuff_HeroBlindComponent:Exit(go)
  game.Level.SetVariable("DEBUFF_Disable_Offscreen_Indicators", false)
  go:RemoveMarker("HideOffScreenIndicators")
  go:EnableLockOnSystem(1)
end
function Debuff_HeroBlindComponent:Update(go)
end
local Debuff_HeroCursedComponent = classlib.Class("Debuff_HeroCursedComponent")
function Debuff_HeroCursedComponent:init()
  self.isOn = false
end
function Debuff_HeroCursedComponent:IsAvailable(go)
  local retVal = false
  if go:PickupIsAcquired("Debuff_Hero_Cursed") then
    retVal = true
  end
  return retVal
end
function Debuff_HeroCursedComponent:Enter(go)
  go:MeterSetValue("CursedActive", go:MeterGetValue("Health"))
end
function Debuff_HeroCursedComponent:Exit(go)
  go:MeterSetValue("Health", go:MeterGetValue("CursedActive"))
  go:MeterSetValue("CursedActive", 0)
end
function Debuff_HeroCursedComponent:Update(go)
end
local Debuff_HeroDazeComponent = classlib.Class("Debuff_HeroDazeComponent")
function Debuff_HeroDazeComponent:init()
  self.isOn = false
  self.dazeCameraSway = {
    EffectName = "FSE_SWAY_DEBUFF_DAZE",
    Duration = 20
  }
end
function Debuff_HeroDazeComponent:IsAvailable(go)
  local retVal = false
  if go:PickupIsAcquired("Debuff_Hero_Daze") then
    retVal = true
  end
  return retVal
end
function Debuff_HeroDazeComponent:Enter(go)
  go:EnableLockOnSystem(0)
end
function Debuff_HeroDazeComponent:Exit(go)
  game.FX.StopEffect(self.dazeCameraSway)
  go:EnableLockOnSystem(1)
end
function Debuff_HeroDazeComponent:Update(go)
  if go:HasMarker("Aiming") then
    game.FX.SubmitEffect(self.dazeCameraSway)
  end
end
local RageModeComponent = classlib.Class("RageModeComponent")
function RageModeComponent:init()
  self.isOn = false
end
function RageModeComponent:IsAvailable(go)
  local retVal = false
  if go:PickupIsAcquired("RageMode") and (go:PickupGetStage("RageMode") == 1 or go:PickupGetStage("RageMode") == 2) then
    retVal = true
  end
  return retVal
end
function RageModeComponent:Enter(go)
  go.Pad:SetLightColor(16733440)
  go:StartAnimation({Animation = "RageMode00", Tween = 0.2})
end
function RageModeComponent:Exit(go)
  go.Pad:ResetLightColor()
  go:StartAnimation({
    Animation = "RageMode00_fadeout",
    Tween = 0.2
  })
  go:PickupAcquire("RageModeExit")
end
function RageModeComponent:Update(go)
  if go:PickupIsAcquired("Debuff_Hero_Frost") then
    go:PickupRelinquish("Debuff_Hero_Frost")
  end
  if go:PickupIsAcquired("Debuff_Hero_Freeze") then
    go:PickupRelinquish("Debuff_Hero_Freeze")
  end
  if go:PickupIsAcquired("Debuff_Hero_Burn") then
    go:PickupRelinquish("Debuff_Hero_Burn")
  end
  if go:PickupIsAcquired("Debuff_Hero_Poison_Short") then
    go:PickupRelinquish("Debuff_Hero_Poison_Short")
  end
  if go:PickupIsAcquired("Debuff_Hero_Blind") then
    go:PickupRelinquish("Debuff_Hero_Blind")
  end
  if go:PickupIsAcquired("Debuff_Hero_Daze") then
    go:PickupRelinquish("Debuff_Hero_Daze")
  end
  go:MeterSetValue("Frost", 0)
  go:MeterSetValue("Burn", 0)
  go:MeterSetValue("Poison", 0)
  go:MeterSetValue("Blind", 0)
  go:MeterSetValue("Daze", 0)
  if go:PickupIsAcquired("ForceRageModeDisabledLTW") then
    go:PickupSetStage("RageMode", 2)
  end
end
local UpdateComponents = function(go, attachedComponents)
  for _, component in ipairs(attachedComponents) do
    if component:IsAvailable(go) then
      if component.isOn == false then
        if component.Enter then
          component:Enter(go)
        end
        component.isOn = true
      end
      if component.Update then
        component:Update(go)
      end
    elseif component.isOn == true then
      component.isOn = false
      if component.Exit then
        component:Exit(go)
      end
    end
  end
end
local StartComponents = function(go, attachedComponents)
  for _, component in ipairs(attachedComponents) do
    if component.OnBrainInit then
      component:OnBrainInit(go)
    end
  end
end
return {
  StartComponents = StartComponents,
  UpdateComponents = UpdateComponents,
  Debuff_HeroBlindComponent = Debuff_HeroBlindComponent,
  Debuff_HeroFrostComponent = Debuff_HeroFrostComponent,
  Debuff_HeroFreezeComponent = Debuff_HeroFreezeComponent,
  Debuff_HeroBurnComponent = Debuff_HeroBurnComponent,
  Debuff_HeroPoisonComponent = Debuff_HeroPoisonComponent,
  Debuff_HeroCursedComponent = Debuff_HeroCursedComponent,
  Debuff_HeroDazeComponent = Debuff_HeroDazeComponent,
  RageModeComponent = RageModeComponent
}
