local profile = require("core.profile")
local GetParentTrace = function(go)
  local result = go:GetName()
  local parent = go.Parent
  while parent ~= nil do
    local parentName = tostring(parent:GetName())
    if parent.IsRefNode then
      parentName = parentName .. "(refnode)"
    end
    result = parentName .. "|" .. result
    parent = parent.Parent
  end
  return "Game Object Hierarchy: " .. result
end
local DisplayAnimDebug = function(objectT, args)
  local debugTable = {}
  local xCoord = 0
  local yCoord = 0
  if args then
    if args.X then
      xCoord = args.X
    end
    if args.Y then
      yCoord = args.Y
    end
  end
  debugTable.X = xCoord
  debugTable.Y = yCoord
  debugTable.Title = "Lua Object Anim Debug"
  debugTable.TitleColor = engine.Vector.New(255, 153, 51)
  debugTable[#debugTable + 1] = {
    "Object  ",
    "Animation  ",
    "Frame  ",
    "Total_Frames  ",
    "Percentage"
  }
  local AddEntry = function(obj)
    if obj.IsRefnode then
      obj = obj.Child
    end
    debugTable[#debugTable + 1] = {
      obj:GetName(),
      obj:GetAnimationName(),
      string.format("%1.0f", obj.AnimFrame),
      string.format("%1.0f", obj.AnimLengthFrames),
      string.format("%1.1f", obj.AnimFrame / obj.AnimLengthFrames * 100) .. " %"
    }
  end
  if type(objectT) == "table" then
    for i = 1, #objectT do
      AddEntry(objectT[i])
    end
  else
    AddEntry(objectT)
  end
  engine.DrawDebugTable(debugTable)
end
local PrintToScreen = function(str, lineOffset, color)
  lineOffset = lineOffset or 0
  local debugTable = {}
  debugTable[1] = {str}
  debugTable.Title = "Print Debug, Line " .. tostring(lineOffset)
  debugTable.TitleColor = color
  debugTable.Y = lineOffset * 3
  engine.DrawDebugTable(debugTable)
end
return profile.WrapLibrary({
  GetParentTrace = GetParentTrace,
  DisplayAnimDebug = DisplayAnimDebug,
  PrintToScreen = PrintToScreen
})
