local profile = require("core.profile")
local ShowFX = function(fxObject, args)
  if args == nil then
    args = {}
  end
  local cycle = args.cycle or false
  if fxObject.IsRefnode then
    fxObject = fxObject.Child
  end
  fxObject:JumpAnimToPercent(0)
  fxObject:ShowParticles()
  fxObject:ShowParticleEmitter()
  fxObject:ShowLights()
  fxObject:ShowModel()
  if cycle then
    fxObject:PlayAnimCycle()
  else
    fxObject:PlayAnimToEnd()
  end
  for _, d in pairs(fxObject.Descendants) do
    if d:IsDescendantDynamicallyParentedTo(fxObject) == false then
      d:JumpAnimToPercent(0)
      d:ShowParticles()
      d:ShowParticleEmitter()
      d:ShowLights()
      d:ShowModel()
      if cycle then
        d:PlayAnimCycle()
      else
        d:PlayAnimToEnd()
      end
    end
  end
end
local HideFX = function(fxObject, args)
  if args == nil then
    args = {}
  end
  local immediate = args.immediate or false
  local playAnimReverse = args.playAnimReverse or false
  if fxObject.IsRefnode then
    fxObject = fxObject.Child
  end
  if immediate then
    fxObject:HideParticles()
    fxObject:JumpAnimToFrame(0)
    fxObject:PauseAnim()
  elseif playAnimReverse then
    fxObject:PlayAnimToEnd(-1)
  end
  fxObject:HideLights()
  fxObject:HideParticleEmitter()
  for _, d in pairs(fxObject.Descendants) do
    if d:IsDescendantDynamicallyParentedTo(fxObject) == false then
      d:HideLights()
      if immediate then
        d:HideParticles()
        d:JumpAnimToFrame(0)
        d:PauseAnim()
      elseif playAnimReverse then
        d:PlayAnimToEnd(-1)
      end
      d:HideParticleEmitter()
    end
  end
end
local AddScreenShake = function(args)
  local params
  if args ~= nil then
    params = {
      EffectName = args.EffectName or "FSE_shake_GENERIC",
      Duration = args.Duration or 1
    }
  else
    params = {
      EffectName = "FSE_shake_GENERIC",
      Duration = 1
    }
  end
  game.FX.SubmitEffect(params)
end
local AddControllerRumble = function(args)
  local params
  if args ~= nil then
    params = {
      EffectName = args.EffectName or "FFB_SMALL",
      Duration = args.Duration or 1
    }
  else
    params = {EffectName = "FFB_SMALL", Duration = 1}
  end
  game.FX.SubmitEffect(params)
end
return profile.WrapLibrary({
  ShowFX = ShowFX,
  HideFX = HideFX,
  AddScreenShake = AddScreenShake,
  AddControllerRumble = AddControllerRumble
})
