local profile = require("core.profile")
local CreateInteractZone_Carryable_360 = function(obj, promptJoint)
  if obj == nil or promptJoint == nil then
    engine.Error("Interact zone creation requires an object and a prompt joint")
  end
  local template = {
    name = "Throwable 360",
    playerFrontAngleMax = 90,
    playerFrontAngleWeight = 1,
    interactFrontAngleWeight = 0,
    interactFrontAngleMax = 361,
    yRangeMax = 2,
    xzRange = 2,
    xzRangeMax = 2,
    hintXZRange = 3,
    hintYRange = 2,
    onScreenPercentMin = 1,
    onScreenPercentMax = 0.01
  }
  local interactZone = game.InteractZone.New(obj, promptJoint)
  interactZone:SetTemplateValues(template)
  interactZone:SetInteractCarryAllowed()
  interactZone:SetTags("NotAllowedOnBoat")
  interactZone:SetTags("NotInRageMode")
  return interactZone
end
return profile.WrapLibrary({CreateInteractZone_Carryable_360 = CreateInteractZone_Carryable_360})
