local profile = require("core.profile")
local CreateInteractZone_LootPickup_360 = function(obj, promptJoint)
  if obj == nil or promptJoint == nil then
    engine.Error("Interact zone creation requires an object and a prompt joint")
  end
  local template = {
    name = "Loot Pickup 360",
    interactFrontAngleMax = 360,
    yRangeMax = 2,
    xzRange = 1.5,
    xzRangeMax = 1.5,
    hintXZRange = 3,
    hintYRange = 2,
    onScreenPercentMin = 1,
    onScreenPercentMax = 0.01,
    onScreenPercentWeight = 0,
    cameraFrontAngleMax = 360
  }
  local interactZone = game.InteractZone.New(obj, promptJoint)
  interactZone:SetTemplateValues(template)
  interactZone:SetTags("NotAllowedOnBoat")
  interactZone:SetTags("NotInRageMode")
  interactZone:SetTags("NotInCombat")
  interactZone:SetTags("CarryActive")
  interactZone:SetPromptIconSet({
    normal = "WORLD_INTERACT_LOOT",
    unavailable = "WORLD_INTERACT_UNAVAILABLE_LOOT",
    locked = "WORLD_INTERACT_LOCKED_LOOT",
    hint = "WORLD_INTERACT_HINT_LOOT"
  })
  return interactZone
end
return profile.WrapLibrary({CreateInteractZone_LootPickup_360 = CreateInteractZone_LootPickup_360})
