local profile = require("core.profile")
local CreateInteractZone_Standard_90 = function(obj, promptJoint)
  if obj == nil or promptJoint == nil then
    engine.Error("Interact zone creation requires an object and a prompt joint")
  end
  local template = {
    name = "Standard 90",
    interactFrontAngleMax = 90,
    yRangeMax = 2,
    xzRangeMax = 3,
    hintXZRange = 4,
    hintYRange = 2,
    onScreenPercentMin = 1,
    onScreenPercentMax = 0.01
  }
  local interactZone = game.InteractZone.New(obj, promptJoint)
  interactZone:SetTemplateValues(template)
  interactZone:SetTags("NotAllowedOnBoat")
  interactZone:SetTags("NotInRageMode")
  interactZone:SetTags("NotInCombat")
  interactZone:SetTags("CarryActive")
  return interactZone
end
local CreateInteractZone_Standard_180 = function(obj, promptJoint)
  if obj == nil or promptJoint == nil then
    engine.Error("Interact zone creation requires an object and a prompt joint")
  end
  local template = {
    name = "Standard 180",
    yRangeMax = 2,
    xzRange = 2,
    xzRangeMax = 2,
    hintXZRange = 5,
    hintYRange = 2,
    onScreenPercentMin = 1,
    onScreenPercentMax = 0.01
  }
  local interactZone = game.InteractZone.New(obj, promptJoint)
  interactZone:SetTemplateValues(template)
  interactZone:SetTags("NotAllowedOnBoat")
  interactZone:SetTags("NotInRageMode")
  interactZone:SetTags("NotInCombat")
  interactZone:SetTags("CarryActive")
  return interactZone
end
local CreateInteractZone_Standard_360 = function(obj, promptJoint)
  if obj == nil or promptJoint == nil then
    engine.Error("Interact zone creation requires an object and a prompt joint")
  end
  local template = {
    name = "Standard 360",
    interactFrontAngleMax = 360,
    xzRange = 2,
    xzRangeMax = 2,
    hintXZRange = 5,
    hintYRange = 2,
    onScreenPercentMin = 1,
    onScreenPercentMax = 0.01
  }
  local interactZone = game.InteractZone.New(obj, promptJoint)
  interactZone:SetTemplateValues(template)
  interactZone:SetTags("NotAllowedOnBoat")
  interactZone:SetTags("NotInRageMode")
  interactZone:SetTags("NotInCombat")
  return interactZone
end
return profile.WrapLibrary({
  CreateInteractZone_Standard_90 = CreateInteractZone_Standard_90,
  CreateInteractZone_Standard_180 = CreateInteractZone_Standard_180,
  CreateInteractZone_Standard_360 = CreateInteractZone_Standard_360
})
