local profile = require("core.profile")
local CreateInteractZone_Throwable_360 = function(obj, promptJoint)
  if obj == nil or promptJoint == nil then
    engine.Error("Interact zone creation requires an object and a prompt joint")
  end
  local template = {
    name = "Throwable 360",
    interactFrontAngleMax = 360,
    yRangeMax = 0.55,
    xzRangeMax = 2.5,
    hintXZRange = 3,
    hintYRange = 2,
    onScreenPercentMin = 1,
    onScreenPercentMax = 0.01
  }
  local interactZone = game.InteractZone.New(obj, promptJoint)
  interactZone:SetTemplateValues(template)
  interactZone:SetTags("NotAllowedOnBoat")
  interactZone:SetTags("NotInRageMode")
  interactZone:SetTags("ThrowableCrystal")
  interactZone:SetTags("CarryActive")
  return interactZone
end
return profile.WrapLibrary({CreateInteractZone_Throwable_360 = CreateInteractZone_Throwable_360})
