local profile = require("core.profile")
local EnableInteractZoneGlint = function(interactZone)
  interactZone:SetHintXZRange(5)
  interactZone:SetGlintYRange(8)
  interactZone:SetGlintXZRange(25)
end
local OverrideInteractZone = function(interactZone, args)
  if args then
    if args.angle then
      interactZone:SetInteractFrontAngle(args.angle)
    end
    if args.angleWeight then
      interactZone:SetInteractFrontAngleWeight(args.angleWeight)
    end
    if args.hintAngle then
      interactZone:SetHintAngle(args.hintAngle)
    end
    if args.xzRange then
      interactZone:SetXZRange(args.xzRange)
    end
    if args.hintXZRange then
      interactZone:SetHintXZRange(args.hintXZRange)
    end
    if args.yRange then
      interactZone:SetYRange(args.yRange)
    end
    if args.useLOSTest then
      interactZone:SetEnableLineOfSightTest(args.useLOSTest)
    end
    if args.onScreenPercent then
      interactZone:SetOnScreenPercent(args.onScreenPercent)
    end
    if args.onScreenPercentWeight then
      interactZone:SetOnScreenPercentWeight(args.onScreenPercentWeight)
    end
    if args.playerAngle then
      interactZone:SetPlayerFrontAngle(args.playerAngle)
    end
    if args.playerAngleWeight then
      interactZone:SetPlayerFrontAngleWeight(args.playerAngleWeight)
    end
    if args.cameraAngle then
      interactZone:SetCameraFrontAngle(args.cameraAngle)
    end
    if args.cameraAngleWeight then
      interactZone:SetCameraFrontAngleWeight(args.cameraAngleWeight)
    end
    if args.interactPlayerAngle then
      interactZone:SetInteractFrontPlayerFrontAngle(args.interactPlayerAngle)
    end
    if args.interactPlayerAngleWeight then
      interactZone:SetInteractFrontPlayerFrontAngleWeight(args.interactPlayerAngleWeight)
    end
  end
end
local OverrideInteractZoneTags = function(interactZone, tag, value)
  if value then
    interactZone:SetTags(tag)
  else
    interactZone:ClearTags(tag)
  end
end
return profile.WrapLibrary({
  EnableInteractZoneGlint = EnableInteractZoneGlint,
  OverrideInteractZone = OverrideInteractZone,
  OverrideInteractZoneTags = OverrideInteractZoneTags
})
