local profile = require("core.profile")
local FindSingleAIByMarker = function(markerName)
  local objArray = game.World.FindGameObjectsByMarker(markerName)
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil and obj:GetCreature():GetAI() ~= nil then
      return obj:GetCreature():GetAI()
    end
  end
  return nil
end
local GetSingleAIByMarker = function(markerName)
  local obj = FindSingleAIByMarker(markerName)
  if obj == nil then
    error("GetSingleAIByMarker - No AI characters exist with marker '" .. markerName .. "'")
  end
  return obj
end
local FindAllAIByMarker = function(markerName)
  local result = {}
  local objArray = game.World.FindGameObjectsByMarker(markerName)
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil and obj:GetCreature():GetAI() ~= nil then
      table.insert(result, obj:GetCreature():GetAI())
    end
  end
  return result
end
local MarkerIDsMatch = function(marker01, marker02)
  if marker01 == game.LargeInteger.HashString(marker02) then
    return true
  else
    return false
  end
end
return profile.WrapLibrary({
  FindSingleAIByMarker = FindSingleAIByMarker,
  GetSingleAIByMarker = GetSingleAIByMarker,
  FindAllAIByMarker = FindAllAIByMarker,
  MarkerIDsMatch = MarkerIDsMatch
})
