local profile = require("core.profile")
local GetAngleBetweenVector = function(v1, v2)
  return math.deg(math.atan2(v1.x * v2.z - v1.z * v2.x, v1.x * v2.x + v1.z * v2.z))
end
local GetPointAlongLine = function(point1, point2, length)
  local position = (point2 - point1):Normalized() * length + point1
  return position
end
local GetPositionBetweenTwoPoints = function(point1, point2, percent)
  percent = percent or 0.5
  if 1 < percent then
    percent = 1
  elseif percent < 0 then
    percent = 0
  end
  local magnitude = game.AIUtil.Distance(point1, point2) * percent
  local position = (point2 - point1):Normalized() * magnitude + point1
  return position
end
local GetXZDistanceBetweenTwoPoints = function(v1, v2)
  if v1 ~= nil and v2 ~= nil then
    local dif = v1 - v2
    dif.y = 0
    return dif:Length()
  end
  return nil
end
return profile.WrapLibrary({
  GetAngleBetweenVector = GetAngleBetweenVector,
  GetPointAlongLine = GetPointAlongLine,
  GetPositionBetweenTwoPoints = GetPositionBetweenTwoPoints,
  GetXZDistanceBetweenTwoPoints = GetXZDistanceBetweenTwoPoints
})
