local profile = require("core.profile")
local RequiredCineNumber = {
  ["010_Forest_010"] = nil,
  ["010_Forest_020"] = 30,
  ["020_RiverPass_010"] = 110,
  ["020_RiverPass_020"] = 137,
  ["030_Caldera_010"] = 165,
  ["040_Foothills_010"] = 183,
  ["050_Alfheim_010"] = 187,
  ["050_Alfheim_020"] = 210,
  ["050_Alfheim_030"] = 230,
  ["060_PeaksPass_010"] = 263,
  ["070_Caldera_010"] = 330,
  ["080_Stonemason_010"] = 340,
  ["080_Stonemason_020"] = 350,
  ["090_Caldera_010"] = 360,
  ["110_Helheim_010"] = 360,
  ["120_HelheimR_010"] = 460,
  ["130_Caldera_010"] = 510,
  ["140_Jotunheim_010"] = 520
}
local IsLoaded = function(playgo_name)
  if not RequiredCineNumber[playgo_name] then
    error("Invalid PlayGo Name: " .. tostring(playgo_name))
  end
  if game.Level.GetVariable("_PlayGo_ForceFail") then
    return false
  end
  return game.UI.IsPlayGoDownloaded(playgo_name)
end
return profile.WrapLibrary({RequiredCineNumber = RequiredCineNumber, IsLoaded = IsLoaded})
