local profile = require("core.profile")
local ActivateQuest = function(questName)
  if questName ~= nil then
    local questState = game.QuestManager.GetQuestState(questName)
    if questState == "Inactive" then
      game.QuestManager.StartQuest(questName)
    else
      print("Attempting to activate a quest that is not marked as inactive. Quest: " .. questName .. ", QuestState: " .. questState)
      return false
    end
  else
    error("No quest name passed to ActivateQuest")
    return false
  end
  return true
end
local CompleteQuest = function(questName)
  if questName ~= nil then
    local questState = game.QuestManager.GetQuestState(questName)
    if questState == "Active" then
      game.QuestManager.ProposeQuestState(questName, "Complete")
    else
      print("Attempting to complete a quest that is not marked as active. Quest: " .. questName .. ", QuestState: " .. questState)
      return false
    end
  else
    error("No quest name passed to CompleteQuest")
    return false
  end
  return true
end
local ActivateAndIncrementQuest = function(questName)
  if questName ~= nil then
    local questState = game.QuestManager.GetQuestState(questName)
    if questState == "Inactive" then
      game.QuestManager.StartQuest(questName)
      game.QuestManager.IncrementQuestProgress(questName, 1)
    elseif questState == "Active" then
      game.QuestManager.IncrementQuestProgress(questName, 1)
    else
      print("Attempting to activate or increment a quest that is not in a supported state. Quest: " .. questName .. ", QuestState: " .. questState)
    end
    return false
  end
  return true
end
return profile.WrapLibrary({
  ActivateQuest = ActivateQuest,
  CompleteQuest = CompleteQuest,
  ActivateAndIncrementQuest = ActivateAndIncrementQuest
})
