local profile = require("core.profile")
local CreateSonInteractZone = function(interactZone)
  interactZone:SetAsSonInteract()
  interactZone:SetPromptIconSet({
    normal = "WORLD_INTERACT_SON",
    unavailable = "WORLD_INTERACT_HINT",
    locked = "WORLD_INTERACT_LOCKED",
    hint = "WORLD_INTERACT_HINT"
  })
end
local CreateSonInteractZone_Dispell_180 = function(obj, promptJoint)
  if obj == nil or promptJoint == nil then
    engine.Error("Son interact zone creation requires an object and a prompt joint")
  end
  local template = {
    name = "Son dispell 180",
    interactFrontAngleMax = 180,
    yRangeMax = 4,
    xzRange = 12,
    xzRangeMax = 12,
    hintXZRange = 20,
    hintYRange = 4,
    onScreenPercentMin = 1,
    onScreenPercentMax = 0.01
  }
  local sonInteractZone = game.InteractZone.New(obj, promptJoint)
  sonInteractZone:SetTemplateValues(template)
  sonInteractZone:SetTags("NotWhileSonInteracting")
  sonInteractZone:SetTags("NotAllowedOnBoat")
  sonInteractZone:SetRequiresSonUnoccupied(true)
  CreateSonInteractZone(sonInteractZone)
  return sonInteractZone
end
return profile.WrapLibrary({CreateSonInteractZone = CreateSonInteractZone, CreateSonInteractZone_Dispell_180 = CreateSonInteractZone_Dispell_180})
