local Available = function()
  return game.Blackboard ~= nil
end
local GetListLength = function(bboard, baseIndex)
  return bboard:GetNumber(baseIndex)
end
local SetListElement = function(bboard, baseIndex, elementIndex, element)
  local index = baseIndex + elementIndex
  if element ~= nil then
    bboard:Set(index, element)
  else
    bboard:Erase(index)
  end
end
local GetListElement = function(bboard, baseIndex, elementIndex)
  local index = baseIndex + elementIndex
  local item = bboard:GetNumber(index)
  if item == nil then
    item = bboard:GetObject(index)
    if item == nil then
      item = bboard:GetBoolean(index)
      if item == nil then
        item = bboard:GetVector(index)
      end
    end
  end
  return item
end
local EraseList = function(bboard, baseIndex)
  local length = bboard:GetNumber(baseIndex)
  assert(length)
  bboard:Erase(baseIndex)
  if 0 < length then
    for i = 1, length do
      bboard:Erase(baseIndex + i)
    end
  end
end
local SetList = function(bboard, baseIndex, list, length)
  if length == nil then
    length = #list
  end
  bboard:Set(baseIndex, length)
  if 0 < length then
    for i = 1, length do
      local item = list[i]
      SetListElement(bboard, baseIndex, i, item)
    end
  end
end
local GetList = function(bboard, baseIndex)
  local result = {}
  local length = bboard:GetNumber(baseIndex)
  if 0 < length then
    for i = 1, length do
      local item = GetListElement(bboard, baseIndex, i)
      result[1 + #result] = item
    end
  end
  return result
end
return {
  Available = Available,
  GetListLength = GetListLength,
  SetListElement = SetListElement,
  GetListElement = GetListElement,
  EraseList = EraseList,
  SetList = SetList,
  GetList = GetList
}
