local profile = require("core.profile")
local uiCalls = require("ui.uicalls")
local LD = require("design.LevelDesignLibrary")
local FastTravelPointDiscovered = function()
  print("new mystic gateway to brok discovered")
end
local FastTravelPointDiscoveredStageTwo = function()
  print("new mystic gateway discovered")
end
local AxeSwingTutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18024,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local BackAttack_Tutorial = function()
  if game.GetQuickTurnOptionNumber() == 0 then
    uiCalls.SendSidebarDesignerMessage({
      Text = 40908,
      DisplayTime = 20,
      Critical = true
    })
  elseif game.GetQuickTurnOptionNumber() == 1 then
    uiCalls.SendSidebarDesignerMessage({
      Text = 40906,
      MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
      DisplayTime = 20,
      Critical = true
    })
  elseif game.GetQuickTurnOptionNumber() == 2 then
    uiCalls.SendSidebarDesignerMessage({
      Text = 18025,
      MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
      DisplayTime = 20,
      Critical = true
    })
  end
end
local BackAttackAdjust_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 40916,
    DisplayTime = 12,
    OptionsOverride = {
      Override = uiCalls.msgParam.OPTIONS_SETTINGS,
      OverrideParams = {
        "ControllerSettings"
      }
    }
  })
end
local Indicator_Tutorial_Splash_01 = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 40913,
    Title = 40091,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_PORTRAIT_SMALL,
    TextStyle = "NewBaseHeader6_LeftCenter",
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_NOPAUSE,
    ImageMaterialName = "OffScreenIndicatorGold_Portrait"
  })
end
local Indicator_Tutorial_Splash_02 = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 40914,
    Title = 40091,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_PORTRAIT_SMALL,
    TextStyle = "NewBaseHeader6_LeftCenter",
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_NOPAUSE,
    ImageMaterialName = "OffScreenIndicatorRed_Portrait"
  })
end
local Indicator_Tutorial_Splash_03 = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 40915,
    Title = 40091,
    CompletionHook = {
      LevelName = "Riv085_DangersEntranceLH",
      ObjectName = "Cbt_Riv085_Script",
      HookName = "IndicatorTutorialDone"
    },
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_PORTRAIT_SMALL,
    TextStyle = "NewBaseHeader6_LeftCenter",
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_NOPAUSE,
    ImageMaterialName = "OffScreenIndicatorPurple_Portrait"
  })
end
local Throw_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 26131,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local AxePinTutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18147, 0)
end
local AxePin_PullChain_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18148, 0)
end
local LightArrow_AimAndFire_Tutorial = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 18026,
    Title = 40953,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    ImageMaterialName = "LightArrow_Landscape"
  })
end
local RecallAxe_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18027,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local RecallAndAimAxe_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 20388,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local AimAxe_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18150,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local ThrowAtObjects_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 26993,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local AxeMelee_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18151,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Evade_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 21914,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
  if game.Wallets.HasResource("HERO", "Evade_Tutorial") == false then
    LD.UpdateJournal("Evade_Tutorial", 6)
  end
end
local BlockAndEvade_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 21914,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local HealthBar_Tutorial = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 39659,
    Title = 39660,
    CompletionHook = {
      LevelName = "For660_TempleInterior",
      HookName = "HealthTutorialComplete"
    },
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_NOPAUSE,
    ImageMaterialName = "enemy_healthbar"
  })
end
local BossHealth_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 43274,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    DisplayTime = 12
  })
end
local AimAxeReminder_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18153,
    MessageVariant = uiCalls.msgParam.SIDEBAR_LARGE,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local BareHand_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18154, DisplayTime = 12})
end
local AxeResistance_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 39661,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local BareHandPause_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18154, -1)
end
local StunGrab_Tutorial = function()
  if game.GetRageGrabOptionNumber then
    if game.GetRageGrabOptionNumber() == 1 then
      uiCalls.UI_Event_SendTutorialMessage(44588, -1)
    else
      uiCalls.UI_Event_SendTutorialMessage(18155, -1)
    end
  else
    uiCalls.UI_Event_SendTutorialMessage(18155, -1)
  end
  if game.Wallets.HasResource("HERO", "StunGrab_Tutorial") == false then
    LD.UpdateJournal("StunGrab_Tutorial", 6)
  end
end
local ArrowStun_Tutorial = function()
  if game.GetRageGrabOptionNumber then
    if game.GetRageGrabOptionNumber() == 1 then
      uiCalls.SendSplashScreenDesignerMessage({
        Text = 44589,
        Title = 39663,
        AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
        ImageMaterialName = "enemy_stun"
      })
    else
      uiCalls.SendSplashScreenDesignerMessage({
        Text = 39662,
        Title = 39663,
        AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
        ImageMaterialName = "enemy_stun"
      })
    end
  else
    uiCalls.SendSplashScreenDesignerMessage({
      Text = 39662,
      Title = 39663,
      AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
      ImageMaterialName = "enemy_stun"
    })
  end
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 40912,
    Title = 39663,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    ImageMaterialName = "enemy_stun"
  })
end
local BreakBlock_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18029, uiCalls.msgParam.INFINITE_TIMER)
  if game.Wallets.HasResource("HERO", "BreakBlock_Tutorial") == false then
    LD.UpdateJournal("BreakBlock_Tutorial", 6)
  end
end
local DodgeRoll_Tutorial = function()
  if game.GetSprintOptionNumber then
    if game.GetSprintOptionNumber() == 1 then
      uiCalls.SendSidebarDesignerMessage({
        Text = 44583,
        MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
        DisplayTime = 12,
        Critical = true
      })
    else
      uiCalls.SendSidebarDesignerMessage({
        Text = 18030,
        MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
        DisplayTime = 12,
        Critical = true
      })
    end
  else
    uiCalls.SendSidebarDesignerMessage({
      Text = 18030,
      MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
      DisplayTime = 12,
      Critical = true
    })
  end
end
local EquipBifrost_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18157, 8)
end
local EquipAxe_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18031,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local EquipAxeAndThrow_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 20390,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local FireSonArrow_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18032,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    DisplayTime = 12
  })
end
local SonTrip_Tutorial = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 43020,
    Title = 43021,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_FORCEPAUSE,
    ImageMaterialName = "son_confidence"
  })
end
local ArrowCooldown_Tutorial = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 39664,
    Title = 39665,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_NOPAUSE,
    ImageMaterialName = "atreusarrows"
  })
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 40911,
    Title = 39665,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_NOPAUSE,
    CompletionHook = {
      LevelName = "For700_DeerKill",
      ObjectName = "Cine_DeerHit_Group",
      HookName = "ArrowAcquireTutComplete"
    },
    ImageMaterialName = "AtreusArrowHUD_Landscape"
  })
end
local FireSonArrow_Reminder = function()
  uiCalls.UI_Event_SendTutorialMessage(18159, 12)
end
local Sprint_Tutorial = function()
  if game.GetSprintOptionNumber then
    if game.GetSprintOptionNumber() == 1 then
      uiCalls.UI_Event_SendTutorialMessage(44584, 7)
    else
      uiCalls.UI_Event_SendTutorialMessage(18034, 7)
    end
  else
    uiCalls.UI_Event_SendTutorialMessage(18034, 7)
  end
end
local VibrateInfo_Tutorial = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 18160,
    Title = 40949,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    ImageMaterialName = "shattercrystals"
  })
  uiCalls.SendSidebarDesignerMessage({
    Text = 18169,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local VibrateArrow_Acquire = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 18162,
    Title = 40948,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_FORCEPAUSE,
    ImageMaterialName = "shatterarrows"
  })
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 18162,
    Title = 40948,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_FORCEPAUSE,
    ImageMaterialName = "shatterarrows2"
  })
end
local ArrowToggle_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18035, DisplayTime = 12})
end
local FireDebuffRoll_Tutorial = function()
end
local FrozenDebuffEscape_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18036,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local WeaponizeNightmareBlades_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({Text = 26130, DisplayTime = 12})
end
local BladeSpear_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({Text = 41007, DisplayTime = 12})
end
local BoatEntry_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18037, DisplayTime = 10})
end
local BoatSteering_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18038, DisplayTime = 10})
end
local BasicMove_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18039, DisplayTime = 6})
end
local BasicCamera_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18040,
    DisplayTime = 9,
    OptionsOverride = {
      Override = uiCalls.msgParam.OPTIONS_SETTINGS,
      OverrideParams = {
        "CameraSettings"
      }
    }
  })
end
local DropDown_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18041, DisplayTime = 10})
end
local JumpGaps_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18042,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local JumpGapsClimb_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 39494,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Vault_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18043,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local ClimbControls = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18164,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Rope_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18044, DisplayTime = 5})
end
local BoostSon_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18045,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local SonChainDropTutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18046,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local WallSqueeze_Tutorial = function()
  uiCalls.SendBottomDesignerMessage(18047, 10)
end
local WallPress_Tutorial = function()
  uiCalls.SendBottomDesignerMessage(18048, 10)
end
local Crawl_Tutorial = function()
  uiCalls.SendBottomDesignerMessage(18049, 10)
end
local Cal250_ScornPoleTutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 20391,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
  if game.Wallets.HasResource("HERO", "Cal250_ScornPoleTutorial") == false then
    LD.UpdateJournal("Cal250_ScornPoleTutorial", 6)
  end
end
local Alf600_TempleDoor_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18050, 4)
end
local Alf600_LightArrow_Tutorial = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 18026,
    Title = 40953,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_FORCEPAUSE,
    ImageMaterialName = "bifrostarrows"
  })
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 18026,
    Title = 40953,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_FORCEPAUSE,
    ImageMaterialName = "bifrostarrows2"
  })
end
local LightArrowUnlocks_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 26207,
    DisplayTime = 10,
    OptionsOverride = {
      Override = uiCalls.msgParam.OPTIONS_SKILL_TREE,
      OverrideParams = {"SonBow"}
    }
  })
end
local Alf600_LightArrow_Reminder = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 20393,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local SonGapCarry_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18051, 0)
end
local Cal820_MimirsEyeAquistion_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18052, -1)
end
local Xpl100_KeyFound_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18053, -1)
end
local Xpl100_KeyPlaced_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18054, -1)
end
local Xpl100_DoorRequiresTwoKeys_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18055, -1)
end
local For300_BaldurBlock_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18056,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local For300_BaldurDodge_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18057,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local For300_BaldurDodge_Tutorial2 = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 24790,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local For300_BaldirDodgeAttacl_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18165,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Peak800_BaldurMMAOffense_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18166,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Peak800_BaldurMMAOffense_Tutorial_Bottom = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18166,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local Peak800_BaldurMMADefense_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18167,
    MessageVariant = uiCalls.msgParam.SIDEBAR_LARGE,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local For300_BaldurTreeBat = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18058,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local For300_RageThrow_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18059,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local For300_ActivateRageMode_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18060,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
  if game.Wallets.HasResource("HERO", "RageMode_Tutorial") == false then
    LD.UpdateJournal("RageMode_Tutorial", 6)
  end
end
local For300_BuildRage_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18061,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local For300_RageThrowAndActivate_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18168,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local For350_PressWall_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18062,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local For800_Troll_Kill_Tutorial = function()
  if game.GetRageGrabOptionNumber then
    if game.GetRageGrabOptionNumber() == 1 then
      uiCalls.SendSidebarDesignerMessage({
        Text = 44587,
        MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
        AdvanceType = uiCalls.msgParam.INFINITE_TIMER
      })
    else
      uiCalls.SendSidebarDesignerMessage({
        Text = 18064,
        MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
        AdvanceType = uiCalls.msgParam.INFINITE_TIMER
      })
    end
  else
    uiCalls.SendSidebarDesignerMessage({
      Text = 18064,
      MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER
    })
  end
end
local HelR30_WitchWiggle_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18065, 6)
end
local Jot100_CalderaWarp_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18066, 0)
end
local Nid000_FogSlightly_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18067, 3)
end
local Nid000_FogGreatly_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18068, 3)
end
local Nid000_FogCompletely_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18069, 3)
end
local Nid000_FogImmunity_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18070, 3)
end
local Nid000_BewareTheFog_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18071, -1)
end
local Nid00_FindJewels_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18072, -1)
end
local Nid000_ValkyrieKeystone_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18073, -1)
end
local Peak550_CommandSon_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18046,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Peak550_DragonMeleeHint_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 31064,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    DisplayTime = 10
  })
end
local Peak550_CrystalThrowHint_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 31065,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    DisplayTime = 10
  })
  uiCalls.SendSidebarDesignerMessage({
    Text = 40870,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    DisplayTime = 15
  })
end
local Peak550_CrystalThrowHint_Splash = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 31065,
    Title = 40871,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS
  })
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 40870,
    Title = 40871,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS
  })
end
local Peak550_DragonCombatHints_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 31066,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    DisplayTime = 10
  })
end
local Peak550_DragonCombatHints_Splash = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 31066,
    Title = 40871,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS
  })
end
local Peak720_IntactCrystals_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18075, 8)
end
local Peak720_ThrowableCrystal_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18169, 8)
  uiCalls.UI_Event_SendTutorialMessage(18170, 8)
  if game.Wallets.HasResource("HERO", "ThrowableCrystals_Tutorial") == false then
    LD.UpdateJournal("ThrowableCrystals_Tutorial", 6)
  end
end
local Stn100_Entrance_TempWarpMessage = function()
  uiCalls.UI_Event_SendDesignerMessage(18079, 6)
end
local Stn500_CrackedLake_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18080, 4)
end
local Stn430_PuzzleSolved_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18081, 5)
end
local Stn430_RunePuzzleHint_Seasons = function()
  uiCalls.UI_Event_SendDesignerMessage(18171, 0)
end
local Stn700_SnowBlind_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18172,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local Stn700_MagniGrab_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 20394,
    DisplayTime = 5,
    Critical = true
  })
end
local Stn700_MagniKill_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 20395,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local Stn980_CommandSon_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18082, 5)
end
local Stn980_LiftHand_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18083, 5)
end
local Stn980_ChiselClimb_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18084, 3)
end
local Hel600_GuardianDestroyMagicOrb = function()
  uiCalls.UI_Event_SendTutorialMessage(18085, 5)
end
local Hel600_GuardianRageGrab = function()
  uiCalls.UI_Event_SendTutorialMessage(18086, 0)
end
local Hel600_GuardiansChest_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18087,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Hel600_GuardiansChestMash_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18088,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Cal120_BrokImproveBlades_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 25905, DisplayTime = 3})
end
local Musp_GetNumKeys = function()
  local totalKeys = 0
  for i = 1, 5 do
    local keyCount = game.Wallets.GetResourceValue("HERO", "MspArenaKey0" .. i)
    if keyCount <= 0 then
      keyCount = 0
    end
    totalKeys = totalKeys + keyCount
  end
  return totalKeys
end
local Musp_ArenaStart_Tutorial = function(arenaLevel)
  uiCalls.UI_Event_TurnOffDesignerMessage()
  if arenaLevel < 2 then
    uiCalls.SendSplashScreenDesignerMessage({
      Text = 25942,
      Title = 21633,
      AlignCenter = true,
      MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
      Critical = true
    })
  elseif 2 <= arenaLevel then
    local useKeys = game.Level.GetVariable("MUS_KeysRequired")
    if useKeys then
      local totalKeys = Musp_GetNumKeys()
      if 3 <= totalKeys then
        uiCalls.SendSplashScreenDesignerMessage({
          Text = 43925,
          Title = 21633,
          formattedArgs = {totalKeys, 3},
          AlignCenter = true,
          MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
          AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
          Critical = true
        })
      else
        uiCalls.SendSplashScreenDesignerMessage({
          Text = 26133,
          Title = 21633,
          formattedArgs = {totalKeys, 3},
          AlignCenter = true,
          MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
          AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
          Critical = true
        })
      end
    else
      uiCalls.SendSplashScreenDesignerMessage({
        Text = 44011,
        Title = 21633,
        AlignCenter = true,
        MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
        AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
        Critical = true
      })
    end
  end
end
local Musp_ChallengeArena_Tutorial = function(challengeInfo)
  uiCalls.UI_Event_TurnOffDesignerMessage()
  local useKeys = game.Level.GetVariable("MUS_KeysRequired")
  if useKeys and Musp_GetNumKeys() < 3 then
    uiCalls.SendSplashScreenDesignerMessage({
      Text = 43926,
      Title = 43927,
      formattedArgs = {
        Musp_GetNumKeys(),
        3
      },
      AlignCenter = true,
      MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
      Critical = true
    })
  else
    local text, args
    if challengeInfo.challengeType == 0 then
      text = 43928
      local GetMinutesAndSecondsFromString = function(time_str)
        local colonIndex = string.find(time_str, ":")
        return tonumber(string.sub(time_str, 1, colonIndex - 1)), tonumber(string.sub(time_str, colonIndex + 1))
      end
      local best_time_mins, best_time_secs = GetMinutesAndSecondsFromString(challengeInfo.best)
      local last_time_mins, last_time_secs = GetMinutesAndSecondsFromString(challengeInfo.last)
      local gold_time_mins, gold_time_secs = GetMinutesAndSecondsFromString(challengeInfo.gold)
      local silver_time_mins, silver_time_secs = GetMinutesAndSecondsFromString(challengeInfo.silver)
      local bronze_time_mins, bronze_time_secs = GetMinutesAndSecondsFromString(challengeInfo.bronze)
      args = {
        best_time_mins,
        best_time_secs,
        last_time_mins,
        last_time_secs,
        gold_time_mins,
        gold_time_secs,
        silver_time_mins,
        silver_time_secs,
        bronze_time_mins,
        bronze_time_secs
      }
    elseif challengeInfo.challengeType == 1 then
      args = {
        challengeInfo.best,
        challengeInfo.last,
        challengeInfo.gold,
        challengeInfo.silver,
        challengeInfo.bronze
      }
      text = 43929
    else
      args = {
        challengeInfo.best,
        challengeInfo.last,
        challengeInfo.gold,
        challengeInfo.silver,
        challengeInfo.bronze
      }
      text = 43930
    end
    uiCalls.SendSplashScreenDesignerMessage({
      Text = text,
      Title = 43927,
      formattedArgs = args,
      AlignCenter = true,
      MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
      Critical = true
    })
  end
end
local Musp_ChallengeArena_Update = function(challengeType, targetTier, targetTierScore, enemyCount, time)
  uiCalls.UI_Event_ClearAllDesignerMessages()
  local text
  local GetMinutesAndSecondsFromString = function(time_str)
    local colonIndex = string.find(time_str, ":")
    return tonumber(string.sub(time_str, 1, colonIndex - 1)), tonumber(string.sub(time_str, colonIndex + 1))
  end
  if challengeType == 0 then
    if targetTier == "Bronze" then
      text = 43939
    elseif targetTier == "Silver" then
      text = 43938
    elseif targetTier == "Gold" then
      text = 43937
    end
    local target_time_mins, target_time_secs = GetMinutesAndSecondsFromString(targetTierScore)
    local current_time_mins, current_time_secs = GetMinutesAndSecondsFromString(time)
    uiCalls.EnableMechanicText(text, {
      target_time_mins,
      target_time_secs,
      enemyCount,
      current_time_mins,
      current_time_secs
    })
  elseif challengeType == 1 then
    if targetTier == "Bronze" then
      text = 43936
    elseif targetTier == "Silver" then
      text = 43935
    elseif targetTier == "Gold" then
      text = 43934
    end
    local time_remaining_mins, time_remaining_secs = GetMinutesAndSecondsFromString(time)
    uiCalls.EnableMechanicText(text, {
      targetTierScore,
      enemyCount,
      time_remaining_mins,
      time_remaining_secs
    })
  else
    if targetTier == "Bronze" then
      text = 43933
    elseif targetTier == "Silver" then
      text = 43932
    elseif targetTier == "Gold" then
      text = 43931
    end
    uiCalls.EnableMechanicText(text, {targetTierScore, enemyCount})
  end
end
local Musp_ChallengeArena_Complete = function(challengeType, successTier, score)
  local args, text
  if challengeType == 0 then
    local GetMinutesAndSecondsFromString = function(time_str)
      local colonIndex = string.find(time_str, ":")
      return tonumber(string.sub(time_str, 1, colonIndex - 1)), tonumber(string.sub(time_str, colonIndex + 1))
    end
    local score_mins, score_secs = GetMinutesAndSecondsFromString(score)
    args = {score_mins, score_secs}
    if successTier == "Gold" then
      text = 43940
    elseif successTier == "Silver" then
      text = 43942
    elseif successTier == "Bronze" then
      text = 43944
    end
  else
    args = {score}
    if successTier == "Gold" then
      text = 43941
    elseif successTier == "Silver" then
      text = 43943
    elseif successTier == "Bronze" then
      text = 43945
    end
  end
  uiCalls.SendBottomDesignerMessage({
    Text = text,
    formattedArgs = args,
    DisplayTime = 7,
    Critical = true
  })
end
local Nif_ResourceGate_Notification = function(isRift, mistEchoCount, MistOnHand, KeysOnHand)
  if mistEchoCount == -1 then
    mistEchoCount = 0
  end
  if MistOnHand == -1 then
    MistOnHand = 0
  end
  if KeysOnHand == -1 then
    KeysOnHand = 0
  end
  local lamsID
  if isRift then
    lamsID = tostring(MistOnHand) .. "/" .. tostring(mistEchoCount) .. " [MSG: 10955]\n" .. tostring(KeysOnHand) .. "/1" .. " [MSG: 37214]"
  else
    lamsID = tostring(MistOnHand) .. "/" .. tostring(mistEchoCount) .. " [MSG: 10955]"
  end
  uiCalls.EnableMechanicText(lamsID)
end
local Nif_ResourceGate_Tutorial = function(Cost, Current, isRift, currentRiftKeys)
end
local EnemyLevel_Tutorial = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 21916,
    Title = 40918,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_NOPAUSE,
    ImageMaterialName = "enemy_levels"
  })
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 40917,
    Title = 40918,
    CompletionHook = {
      LevelName = "Riv200_DangersMain",
      ObjectName = "Cine_BridgeFall",
      HookName = "EnemyLevelTutorialComplete"
    },
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_NOPAUSE,
    ImageMaterialName = "powerlevels"
  })
end
local SkillPointIntro_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 21917,
    DisplayTime = 12,
    OptionsOverride = {
      Override = uiCalls.msgParam.OPTIONS_SKILL_TREE
    }
  })
end
local SkillPointReminder_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 21919,
    DisplayTime = 10,
    OptionsOverride = {
      Override = uiCalls.msgParam.OPTIONS_SKILL_TREE
    }
  })
end
local SkillPointBladesReminder_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 26129,
    DisplayTime = 10,
    OptionsOverride = {
      Override = uiCalls.msgParam.OPTIONS_SKILL_TREE,
      OverrideParams = {"Blades"}
    }
  })
end
local DoorLocked_Tutorial = function(timer)
  uiCalls.SendBottomDesignerMessage({Text = 18090, DisplayTime = 3})
end
local CrankControls_Wheel_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 40929,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local CrankControls_Chain_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18173,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local CrankControls_Line_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 40930,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local CrankControls_Line_Sideways_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 45119,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local CrankControls_CalBridge_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 40931,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local RealmTravel_Tutorial = function(player, inTutorial)
  local lamsID
  local lamsID_RotateTutorial = 40137
  local lamsID_ConfirmTutorial = 40813
  local lamsID_TravelNonMidgard = 40814
  local lamsID_TravelAll = 40815
  if inTutorial then
    if player:HasMarker("travelTutorial_Rotate") then
      lamsID = lamsID_RotateTutorial
    elseif player:HasMarker("travelTutorial_Confirm") then
      lamsID = lamsID_ConfirmTutorial
    end
  elseif LD.GetCurrentRealm() ~= "Midgard" and game.Level.GetVariable("CAL_RealmUnlocked_Midgard") then
    lamsID = lamsID_TravelAll
  else
    lamsID = lamsID_TravelNonMidgard
  end
  if lamsID ~= nil then
    uiCalls.SendBottomDesignerMessage({
      Text = lamsID,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER
    })
  end
end
local RealmTravel_TwoWayTutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(37231, -1)
end
local GreenStones_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18115, DisplayTime = 6})
end
local TrapSuccess_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18092, 6)
end
local AscendTheCave_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18175, -1)
end
local ObstacleBlocking_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18093, 6)
end
local MissingAbility_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18094, 3)
end
local EncounterComplete_Tutorial = function(waveIdx, timer)
  uiCalls.UI_Event_SendDesignerMessage("Wave: " .. waveIdx .. " Complete!", timer or 2)
end
local AreaFinished_Tutorial = function(areaIdx, timer)
  uiCalls.UI_Event_SendDesignerMessage("Arena " .. areaIdx .. " Finished!", timer or 5)
end
local ChallengeArena_Tutorial = function(arenaIdx, timer)
  uiCalls.UI_Event_SendDesignerMessage("Challenge Arena " .. arenaIdx, timer or -1)
end
local EventFailed_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18095, 5)
end
local EventComplete_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18096, 5)
end
local RunicLock_FirstDoor_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18097, DisplayTime = 5})
end
local RunicLock_FirstChest_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18098, DisplayTime = 5})
end
local RunicLock_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 40816, DisplayTime = 5})
end
local RunicProgress_Tutorial = function(numUsed)
  uiCalls.SendSidebarDesignerMessage({
    Text = 40817,
    DisplayTime = 3,
    formattedArgs = {numUsed},
    Critical = true
  })
end
local Burnables_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18101, 0)
end
local DrainAcquire_Tutorial_2 = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18150,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local DrainAcquire_Tutorial_3 = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18104,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Drain_Tutorial_1 = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 18105,
    Title = 40957,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS_FORCEPAUSE,
    ImageMaterialName = "drain_cd1"
  })
end
local Drain_Tutorial_2 = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18106,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Drain_Tutorial_3 = function()
  uiCalls.SendBottomDesignerMessage({
    Text = 18107,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local Son_Incapacitated_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18108,
    MessageVariant = uiCalls.msgParam.SIDEBAR_LARGE,
    DisplayTime = 5
  })
end
local BoatLoot_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(18110, 3)
end
local EnemyDrop_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18111, DisplayTime = 4})
end
local HealthUpgrade_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(20397, 4)
end
local HealthUpgraded_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(20398, 4)
end
local RageUpgrade_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(20399, 4)
end
local RageUpgraded_Tutorial = function()
  uiCalls.UI_Event_SendDesignerMessage(20400, 4)
end
local FastTravelUnlocked = function()
  uiCalls.UI_Event_SendTutorialMessage(18113, uiCalls.msgParam.ADVANCE_PRESS, {tutorialHeaderText = 18114})
end
local TwoWayTravel_Unlocked = function()
  uiCalls.SendBottomDesignerMessage({18113, DisplayTime = 8})
end
local RunicLock_Door_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({18113, DisplayTime = 8})
end
local XP_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18176, uiCalls.msgParam.ADVANCE_PRESS, {tutorialHeaderText = 18177})
end
local HealthRune_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18115, DisplayTime = 6})
end
local WristArmor_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18178, uiCalls.msgParam.ADVANCE_PRESS, {tutorialHeaderText = 18179})
end
local WaistArmor_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18180, uiCalls.msgParam.ADVANCE_PRESS, {tutorialHeaderText = 18181})
end
local ArmorTrinkets_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18182, uiCalls.msgParam.ADVANCE_PRESS, {tutorialHeaderText = 18183})
end
local RunicAttack_Tutorial_01 = function()
  uiCalls.UI_Event_SendTutorialMessage(26604, -1, {tutorialHeaderText = 26605})
end
local RunicAttack_Tutorial_02 = function()
  uiCalls.UI_Event_SendTutorialMessage(26603, -1, {tutorialHeaderText = 26605})
end
local RunicAttack_Tutorial_Cooldown = function()
  uiCalls.UI_Event_SendTutorialMessage(26602, -1, {tutorialHeaderText = 26605})
end
local Specials_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18186,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local Specials_TutorialReminder = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18186,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local WeaponMomentum_Tutorial_1 = function()
  uiCalls.UI_Event_SendTutorialMessage(18188, -1, {tutorialHeaderText = 18189})
  if game.Wallets.HasResource("HERO", "WeaponMomentum_Tutorial_1") == false then
    LD.UpdateJournal("WeaponMomentum_Tutorial_1", 6)
  end
end
local WeaponComponents_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18190, uiCalls.msgParam.ADVANCE_PRESS, {tutorialHeaderText = 18191})
  if game.Wallets.HasResource("HERO", "WeaponComponents_Tutorial") == false then
    LD.UpdateJournal("WeaponComponents_Tutorial", 6)
  end
end
local CollectResources_Tutorial = function()
  uiCalls.SendBottomDesignerMessage({Text = 18116, DisplayTime = 6})
end
local Compass_Acquire = function()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 26298,
    Title = 40089,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_LANDSCAPE_LARGE,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    ImageMaterialName = "compass",
    Critical = true
  })
end
local Compass_ToDaylight = function()
  uiCalls.SendBottomDesignerMessage({Text = 26309, DisplayTime = 9})
end
local DeerSteadyAim_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18118,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local SteadyAim_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18119,
    DisplayTime = 3,
    Critical = true
  })
end
local FireArrow_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18120,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
local Hotzone_Tutorial = function()
  uiCalls.UI_Event_SendTutorialMessage(18121, 5)
end
local ChiselDoor_Tutorial = function()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18122,
    MessageVariant = uiCalls.msgParam.SIDEBAR_LARGE,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
local HideTutorial = function()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
return profile.WrapLibrary({
  AxePinTutorial = AxePinTutorial,
  AxeSwingTutorial = AxeSwingTutorial,
  BackAttack_Tutorial = BackAttack_Tutorial,
  BackAttackAdjust_Tutorial = BackAttackAdjust_Tutorial,
  Indicator_Tutorial_Splash_01 = Indicator_Tutorial_Splash_01,
  Indicator_Tutorial_Splash_02 = Indicator_Tutorial_Splash_02,
  Indicator_Tutorial_Splash_03 = Indicator_Tutorial_Splash_03,
  AxePin_PullChain_Tutorial = AxePin_PullChain_Tutorial,
  LightArrow_AimAndFire_Tutorial = LightArrow_AimAndFire_Tutorial,
  RecallAxe_Tutorial = RecallAxe_Tutorial,
  RecallAndAimAxe_Tutorial = RecallAndAimAxe_Tutorial,
  AimAxe_Tutorial = AimAxe_Tutorial,
  ThrowAtObjects_Tutorial = ThrowAtObjects_Tutorial,
  EquipBifrost_Tutorial = EquipBifrost_Tutorial,
  EquipAxe_Tutorial = EquipAxe_Tutorial,
  Throw_Tutorial = Throw_Tutorial,
  EquipAxeAndThrow_Tutorial = EquipAxeAndThrow_Tutorial,
  FireSonArrow_Tutorial = FireSonArrow_Tutorial,
  SonTrip_Tutorial = SonTrip_Tutorial,
  FireSonArrow_Reminder = FireSonArrow_Reminder,
  Sprint_Tutorial = Sprint_Tutorial,
  ArrowCooldown_Tutorial = ArrowCooldown_Tutorial,
  BoatEntry_Tutorial = BoatEntry_Tutorial,
  BoatSteering_Tutorial = BoatSteering_Tutorial,
  BasicMove_Tutorial = BasicMove_Tutorial,
  BasicCamera_Tutorial = BasicCamera_Tutorial,
  DropDown_Tutorial = DropDown_Tutorial,
  JumpGaps_Tutorial = JumpGaps_Tutorial,
  JumpGapsClimb_Tutorial = JumpGapsClimb_Tutorial,
  Vault_Tutorial = Vault_Tutorial,
  ClimbControls = ClimbControls,
  Rope_Tutorial = Rope_Tutorial,
  BoostSon_Tutorial = BoostSon_Tutorial,
  SonChainDropTutorial = SonChainDropTutorial,
  WallSqueeze_Tutorial = WallSqueeze_Tutorial,
  WallPress_Tutorial = WallPress_Tutorial,
  Crawl_Tutorial = Crawl_Tutorial,
  Compass_Acquire = Compass_Acquire,
  Compass_ToDaylight = Compass_ToDaylight,
  Cal250_ScornPoleTutorial = Cal250_ScornPoleTutorial,
  Alf600_TempleDoor_Tutorial = Alf600_TempleDoor_Tutorial,
  Alf600_LightArrow_Tutorial = Alf600_LightArrow_Tutorial,
  LightArrowUnlocks_Tutorial = LightArrowUnlocks_Tutorial,
  Alf600_LightArrow_Reminder = Alf600_LightArrow_Reminder,
  SonGapCarry_Tutorial = SonGapCarry_Tutorial,
  Cal820_MimirsEyeAquistion_Tutorial = Cal820_MimirsEyeAquistion_Tutorial,
  Xpl100_KeyFound_Tutorial = Xpl100_KeyFound_Tutorial,
  Xpl100_KeyPlaced_Tutorial = Xpl100_KeyPlaced_Tutorial,
  Xpl100_DoorRequiresTwoKeys_Tutorial = Xpl100_DoorRequiresTwoKeys_Tutorial,
  For300_BaldurBlock_Tutorial = For300_BaldurBlock_Tutorial,
  For300_BaldurDodge_Tutorial = For300_BaldurDodge_Tutorial,
  For300_BaldurDodge_Tutorial2 = For300_BaldurDodge_Tutorial2,
  For300_BaldirDodgeAttacl_Tutorial = For300_BaldirDodgeAttacl_Tutorial,
  Peak800_BaldurMMAOffense_Tutorial = Peak800_BaldurMMAOffense_Tutorial,
  Peak800_BaldurMMAOffense_Tutorial_Bottom = Peak800_BaldurMMAOffense_Tutorial_Bottom,
  Peak800_BaldurMMADefense_Tutorial = Peak800_BaldurMMADefense_Tutorial,
  For300_BaldurTreeBat = For300_BaldurTreeBat,
  For300_RageThrow_Tutorial = For300_RageThrow_Tutorial,
  For300_BuildRage_Tutorial = For300_BuildRage_Tutorial,
  For300_ActivateRageMode_Tutorial = For300_ActivateRageMode_Tutorial,
  For300_RageThrowAndActivate_Tutorial = For300_RageThrowAndActivate_Tutorial,
  For350_PressWall_Tutorial = For350_PressWall_Tutorial,
  HelR30_WitchWiggle_Tutorial = HelR30_WitchWiggle_Tutorial,
  Jot100_CalderaWarp_Tutorial = Jot100_CalderaWarp_Tutorial,
  Nid000_FogSlightly_Tutorial = Nid000_FogSlightly_Tutorial,
  Nid000_FogGreatly_Tutorial = Nid000_FogGreatly_Tutorial,
  Nid000_FogCompletely_Tutorial = Nid000_FogCompletely_Tutorial,
  Nid000_FogImmunity_Tutorial = Nid000_FogImmunity_Tutorial,
  Nid000_BewareTheFog_Tutorial = Nid000_BewareTheFog_Tutorial,
  Nid00_FindJewels_Tutorial = Nid00_FindJewels_Tutorial,
  Nid000_ValkyrieKeystone_Tutorial = Nid000_ValkyrieKeystone_Tutorial,
  Peak720_IntactCrystals_Tutorial = Peak720_IntactCrystals_Tutorial,
  Stn100_Entrance_TempWarpMessage = Stn100_Entrance_TempWarpMessage,
  Stn500_CrackedLake_Tutorial = Stn500_CrackedLake_Tutorial,
  Stn430_PuzzleSolved_Tutorial = Stn430_PuzzleSolved_Tutorial,
  Stn430_RunePuzzleHint_Seasons = Stn430_RunePuzzleHint_Seasons,
  Stn700_SnowBlind_Tutorial = Stn700_SnowBlind_Tutorial,
  Stn700_MagniGrab_Tutorial = Stn700_MagniGrab_Tutorial,
  Stn700_MagniKill_Tutorial = Stn700_MagniKill_Tutorial,
  Stn980_CommandSon_Tutorial = Stn980_CommandSon_Tutorial,
  Stn980_LiftHand_Tutorial = Stn980_LiftHand_Tutorial,
  Stn980_ChiselClimb_Tutorial = Stn980_ChiselClimb_Tutorial,
  Hel600_GuardianRageGrab = Hel600_GuardianRageGrab,
  Hel600_GuardianDestroyMagicOrb = Hel600_GuardianDestroyMagicOrb,
  Hel600_GuardiansChest_Tutorial = Hel600_GuardiansChest_Tutorial,
  Hel600_GuardiansChestMash_Tutorial = Hel600_GuardiansChestMash_Tutorial,
  Peak550_CommandSon_Tutorial = Peak550_CommandSon_Tutorial,
  Peak550_CrystalThrowHint_Tutorial = Peak550_CrystalThrowHint_Tutorial,
  Peak550_CrystalThrowHint_Splash = Peak550_CrystalThrowHint_Splash,
  Peak550_DragonMeleeHint_Tutorial = Peak550_DragonMeleeHint_Tutorial,
  Peak550_DragonCombatHints_Tutorial = Peak550_DragonCombatHints_Tutorial,
  Peak550_DragonCombatHints_Splash = Peak550_DragonCombatHints_Splash,
  Peak720_ThrowableCrystal_Tutorial = Peak720_ThrowableCrystal_Tutorial,
  DoorLocked_Tutorial = DoorLocked_Tutorial,
  CrankControls_Wheel_Tutorial = CrankControls_Wheel_Tutorial,
  CrankControls_Chain_Tutorial = CrankControls_Chain_Tutorial,
  CrankControls_Line_Tutorial = CrankControls_Line_Tutorial,
  CrankControls_Line_Sideways_Tutorial = CrankControls_Line_Sideways_Tutorial,
  CrankControls_CalBridge_Tutorial = CrankControls_CalBridge_Tutorial,
  RealmTravel_Tutorial = RealmTravel_Tutorial,
  RealmTravel_TwoWayTutorial = RealmTravel_TwoWayTutorial,
  GreenStones_Tutorial = GreenStones_Tutorial,
  TrapSuccess_Tutorial = TrapSuccess_Tutorial,
  AscendTheCave_Tutorial = AscendTheCave_Tutorial,
  ObstacleBlocking_Tutorial = ObstacleBlocking_Tutorial,
  MissingAbility_Tutorial = MissingAbility_Tutorial,
  SteadyAim_Tutorial = SteadyAim_Tutorial,
  DeerSteadyAim_Tutorial = DeerSteadyAim_Tutorial,
  FireArrow_Tutorial = FireArrow_Tutorial,
  Hotzone_Tutorial = Hotzone_Tutorial,
  EncounterComplete_Tutorial = EncounterComplete_Tutorial,
  AreaFinished_Tutorial = AreaFinished_Tutorial,
  ChallengeArena_Tutorial = ChallengeArena_Tutorial,
  EventFailed_Tutorial = EventFailed_Tutorial,
  EventComplete_Tutorial = EventComplete_Tutorial,
  ArmorTrinkets_Tutorial = ArmorTrinkets_Tutorial,
  FastTravelUnlocked = FastTravelUnlocked,
  TwoWayTravel_Unlocked = TwoWayTravel_Unlocked,
  WristArmor_Tutorial = WristArmor_Tutorial,
  WaistArmor_Tutorial = WaistArmor_Tutorial,
  CollectResources_Tutorial = CollectResources_Tutorial,
  RunicAttack_Tutorial_01 = RunicAttack_Tutorial_01,
  RunicAttack_Tutorial_02 = RunicAttack_Tutorial_02,
  RunicAttack_Tutorial_Cooldown = RunicAttack_Tutorial_Cooldown,
  Specials_Tutorial = Specials_Tutorial,
  Specials_TutorialReminder = Specials_TutorialReminder,
  WeaponMomentum_Tutorial_1 = WeaponMomentum_Tutorial_1,
  XP_Tutorial = XP_Tutorial,
  WeaponComponents_Tutorial = WeaponComponents_Tutorial,
  HealthRune_Tutorial = HealthRune_Tutorial,
  HideTutorial = HideTutorial,
  RunicLock_Tutorial = RunicLock_Tutorial,
  RunicProgress_Tutorial = RunicProgress_Tutorial,
  RunicLock_FirstDoor_Tutorial = RunicLock_FirstDoor_Tutorial,
  RunicLock_FirstChest_Tutorial = RunicLock_FirstChest_Tutorial,
  RunicLock_Door_Tutorial = RunicLock_Door_Tutorial,
  Burnables_Tutorial = Burnables_Tutorial,
  DrainAcquire_Tutorial_2 = DrainAcquire_Tutorial_2,
  DrainAcquire_Tutorial_3 = DrainAcquire_Tutorial_3,
  Drain_Tutorial_1 = Drain_Tutorial_1,
  Drain_Tutorial_2 = Drain_Tutorial_2,
  Drain_Tutorial_3 = Drain_Tutorial_3,
  Son_Incapacitated_Tutorial = Son_Incapacitated_Tutorial,
  VibrateInfo_Tutorial = VibrateInfo_Tutorial,
  VibrateArrow_Acquire = VibrateArrow_Acquire,
  ArrowToggle_Tutorial = ArrowToggle_Tutorial,
  FastTravelPointDiscovered = FastTravelPointDiscovered,
  FastTravelPointDiscoveredStageTwo = FastTravelPointDiscoveredStageTwo,
  ChiselDoor_Tutorial = ChiselDoor_Tutorial,
  Musp_GetNumKeys = Musp_GetNumKeys,
  Musp_ArenaStart_Tutorial = Musp_ArenaStart_Tutorial,
  Musp_ChallengeArena_Tutorial = Musp_ChallengeArena_Tutorial,
  Musp_ChallengeArena_Update = Musp_ChallengeArena_Update,
  Musp_ChallengeArena_Complete = Musp_ChallengeArena_Complete,
  Nif_ResourceGate_Notification = Nif_ResourceGate_Notification,
  Nif_ResourceGate_Tutorial = Nif_ResourceGate_Tutorial,
  AxeMelee_Tutorial = AxeMelee_Tutorial,
  Evade_Tutorial = Evade_Tutorial,
  BlockAndEvade_Tutorial = BlockAndEvade_Tutorial,
  AimAxeReminder_Tutorial = AimAxeReminder_Tutorial,
  HealthBar_Tutorial = HealthBar_Tutorial,
  BossHealth_Tutorial = BossHealth_Tutorial,
  BareHand_Tutorial = BareHand_Tutorial,
  AxeResistance_Tutorial = AxeResistance_Tutorial,
  BareHandPause_Tutorial = BareHandPause_Tutorial,
  EnemyLevel_Tutorial = EnemyLevel_Tutorial,
  SkillPointIntro_Tutorial = SkillPointIntro_Tutorial,
  SkillPointReminder_Tutorial = SkillPointReminder_Tutorial,
  SkillPointBladesReminder_Tutorial = SkillPointBladesReminder_Tutorial,
  StunGrab_Tutorial = StunGrab_Tutorial,
  DodgeRoll_Tutorial = DodgeRoll_Tutorial,
  BreakBlock_Tutorial = BreakBlock_Tutorial,
  For800_Troll_Kill_Tutorial = For800_Troll_Kill_Tutorial,
  FireDebuffRoll_Tutorial = FireDebuffRoll_Tutorial,
  FrozenDebuffEscape_Tutorial = FrozenDebuffEscape_Tutorial,
  WeaponizeNightmareBlades_Tutorial = WeaponizeNightmareBlades_Tutorial,
  BladeSpear_Tutorial = BladeSpear_Tutorial,
  BoatLoot_Tutorial = BoatLoot_Tutorial,
  EnemyDrop_Tutorial = EnemyDrop_Tutorial,
  HealthUpgrade_Tutorial = HealthUpgrade_Tutorial,
  HealthUpgraded_Tutorial = HealthUpgraded_Tutorial,
  RageUpgrade_Tutorial = RageUpgrade_Tutorial,
  RageUpgraded_Tutorial = RageUpgraded_Tutorial,
  ArrowStun_Tutorial = ArrowStun_Tutorial,
  Cal120_BrokImproveBlades_Tutorial = Cal120_BrokImproveBlades_Tutorial
})
