local Hide = function(level, array)
  for _, name in ipairs(array) do
    local obj = level:FindGameObject(name)
    if obj then
      obj:Hide()
    else
      error("Can't find GameObject '", name, "'")
    end
  end
end
local Show = function(level, array)
  Hide(level, array)
  local i = math.random(#array)
  local obj = level:FindGameObject(array[i])
  obj:Show()
end
return {Hide = Hide, Show = Show}
