local attributeList = {
  "ReactionEventType",
  "MaxRadius",
  "Banter",
  "TriggerBanterOnce",
  "TriggerByProximity",
  "ReactionCalloutStages",
  "ResetReactionTimer",
  "ContinueUsingLastStage",
  "UseHeadtrackingToSource",
  "ChangeContextBehaviorForLeftRight",
  "IncrementNextStageTimerWhileInRange",
  "StageOneMove",
  "StageTwoMove",
  "StageThreeMove",
  "EnvEventType",
  "InBoatOnly",
  "EnabledOnStart",
  "Context_OnExit",
  "Context_OnExit_Delay",
  "OnStimTriggerCallback",
  "OnZoneEnterCallback",
  "OnZoneExitCallback",
  "OnBanterFireCallback",
  "OnBanterFinishedCallback",
  "OnFinalStageBanterFinishedCallback",
  StageOneBanter = "list",
  StageTwoBanter = "list",
  StageThreeBanter = "list"
}
local CollectLuaTableAttributes = function(level, go)
  local MLT = require("design.MayaLuaTablesLibrary")
  local attributes = go:GetLuaTableAttributes(attributeList)
  attributes.OnStimTriggerCallback = MLT.ExtractCallbacksForEvent(level, go, attributes.OnStimTriggerCallback)
  attributes.OnZoneEnterCallback = MLT.ExtractCallbacksForEvent(level, go, attributes.OnZoneEnterCallback)
  attributes.OnZoneExitCallback = MLT.ExtractCallbacksForEvent(level, go, attributes.OnZoneExitCallback)
  attributes.OnBanterFireCallback = MLT.ExtractCallbacksForEvent(level, go, attributes.OnBanterFireCallback)
  attributes.OnBanterFinishedCallback = MLT.ExtractCallbacksForEvent(level, go, attributes.OnBanterFinishedCallback)
  attributes.OnFinalStageBanterFinishedCallback = MLT.ExtractCallbacksForEvent(level, go, attributes.OnFinalStageBanterFinishedCallback)
  return attributes
end
local TriggerEnvironmentEvent = function(go, attributes, reactionStage, eventTriggeredOnce)
  game.World.QueueEnvironmentEvent(go, go:GetWorldPosition(), attributes, reactionStage, eventTriggeredOnce)
end
return {CollectLuaTableAttributes = CollectLuaTableAttributes, TriggerEnvironmentEvent = TriggerEnvironmentEvent}
