local class = require("core.class")
local levelmonitor = require("level.levelmonitor")
local ButtonMonitor = class.Class("ButtonMonitor", levelmonitor.LevelMonitor)
local callButtonChangedCallback
function ButtonMonitor:OnButtonDown(fn, ...)
  self:OnValue(true, callButtonChangedCallback, self, fn, ...)
end
function ButtonMonitor:OnButtonUp(fn, ...)
  self:OnValue(false, callButtonChangedCallback, self, fn, ...)
end
local AddButtonMonitor = function(button)
  return ButtonMonitor.New(button)
end
function callButtonChangedCallback(value, self, fn, ...)
  fn(self, self.buttonName, ...)
  return true
end
function ButtonMonitor:init(button)
  self.playerPad = game.Player.FindPlayer().Pad
  self.buttonName = button
  self.value = false
  self:Watch(self.watch_callback, self)
  self:Start()
end
function ButtonMonitor:watch_callback()
  local buttonInputName = self.buttonName
  if self.buttonName == "Interact" then
    if game.GetCurrentControllerLayout and game.GetCurrentControllerLayout() ~= "Default Controller" then
      buttonInputName = "Cross"
    else
      buttonInputName = "Circle"
    end
  elseif self.buttonName == "Evade" then
    if game.GetCurrentControllerLayout and game.GetCurrentControllerLayout() ~= "Default Controller" then
      buttonInputName = "Circle"
    else
      buttonInputName = "Cross"
    end
  end
  return self.playerPad[buttonInputName .. "Down"] or false
end
_G.AddButtonMonitor = AddButtonMonitor
return {ButtonMonitor = ButtonMonitor, Add = AddButtonMonitor}
