local class = require("core.class")
local levelmonitor = require("level.levelmonitor")
local EntityVariableMonitor = class.Class("EntityVariableMonitor", levelmonitor.LevelMonitor)
local callVariableChangedCallback
function EntityVariableMonitor:OnVariableChange(fn, ...)
  self:OnChanged(callVariableChangedCallback, self, fn, ...)
end
local AddEntityVariableMonitor = function(entityVarName)
  return EntityVariableMonitor.New(entityVarName)
end
function callVariableChangedCallback(newValue, oldValue, self, fn, ...)
  self:dprint("Entity Variable Monitor triggered: '" .. tostring(self.entityVarName) .. "' changed from '" .. tostring(oldValue) .. "' to '" .. tostring(newValue) .. "'")
  fn(self, newValue, oldValue, ...)
  return true
end
function EntityVariableMonitor:init(entityVarName)
  self.entityVarName = entityVarName
  self.value = game.Level.GetVariable(entityVarName)
  self:Watch(self.watch_callback, self)
  self:Start()
end
function EntityVariableMonitor:watch_callback()
  if self.entityVarName == nil then
    return self.value
  end
  return game.Level.GetVariable(self.entityVarName)
end
_G.AddEntityVariableMonitor = AddEntityVariableMonitor
return {EntityVariableMonitor = EntityVariableMonitor, Add = AddEntityVariableMonitor}
