local profile = require("core.profile")
local entityZoneMonitors, brkMonitors, distMonitors, buttonMonitors, healthMonitors, deathMonitors, audioAnimMonitors
local entityZoneMonitors_LoadLibrary = function()
  if entityZoneMonitors == nil then
    entityZoneMonitors = require("level.entityzonemonitor")
  end
end
local brkMonitors_LoadLibrary = function()
  if brkMonitors == nil then
    brkMonitors = require("level.breakablemonitor")
  end
end
local distMonitors_LoadLibrary = function()
  if distMonitors == nil then
    distMonitors = require("level.distancemonitor")
  end
end
local buttonMonitors_LoadLibrary = function()
  if buttonMonitors == nil then
    buttonMonitors = require("level.buttonmonitor")
  end
end
local healthMonitors_LoadLibrary = function()
  if healthMonitors == nil then
    healthMonitors = require("level.healthmonitor")
  end
end
local deathMonitors_LoadLibrary = function()
  if deathMonitors == nil then
    deathMonitors = require("level.deathmonitor")
  end
end
local audioAnimMonitors_LoadLibrary = function()
  if audioAnimMonitors == nil then
    audioAnimMonitors = require("level.audioanimframemonitor")
  end
end
local CreateEntityZoneMonitor = function(go, zoneNameOrGameObject)
  entityZoneMonitors_LoadLibrary()
  return entityZoneMonitors.Add(go, zoneNameOrGameObject)
end
local CreateEntityVariableMonitor = function(entityVarName)
  return game.Monitor.CreateEntityVariableMonitor(entityVarName)
end
local CreateBreakableMonitor = function(go)
  brkMonitors_LoadLibrary()
  return brkMonitors.Add(go)
end
local CreateDistanceMonitor = function(go1, go2)
  distMonitors_LoadLibrary()
  return distMonitors.Add(go1, go2)
end
local CreateLookAtMonitor = function(position)
  return game.Monitor.CreateLookAtMonitor(position)
end
local CreateAnimFrameMonitor = function(go)
  return game.Monitor.CreateAnimFrameMonitor(go)
end
local CreateAudioAnimFrameMonitor = function(go)
  audioAnimMonitors_LoadLibrary()
  return audioAnimMonitors.Add(go)
end
local CreateHealthMonitor = function(ai)
  healthMonitors_LoadLibrary()
  return healthMonitors.Add(ai)
end
local CreateDeathMonitor = function(ai)
  deathMonitors_LoadLibrary()
  return deathMonitors.Add(ai)
end
local CreateInteractButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Interact")
end
local CreateEvadeButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Evade")
end
local CreateSquareButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Square")
end
local CreateTriangleButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Triangle")
end
local CreateCircleButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Circle")
end
local CreateCrossButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Cross")
end
local CreateLeftButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Left")
end
local CreateRightButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Right")
end
local CreateUpButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Up")
end
local CreateDownButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Down")
end
local CreateL1ButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("L1")
end
local CreateR1ButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("R1")
end
local CreateL2ButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("L2")
end
local CreateR2ButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("R2")
end
local CreateL3ButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("L3")
end
local CreateR3ButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("R3")
end
local CreateStartButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Start")
end
local CreateSelectButtonMonitor = function()
  buttonMonitors_LoadLibrary()
  return buttonMonitors.Add("Select")
end
return profile.WrapLibrary({
  CreateEntityZoneMonitor = CreateEntityZoneMonitor,
  CreateEntityVariableMonitor = CreateEntityVariableMonitor,
  CreateBreakableMonitor = CreateBreakableMonitor,
  CreateDistanceMonitor = CreateDistanceMonitor,
  CreateLookAtMonitor = CreateLookAtMonitor,
  CreateAnimFrameMonitor = CreateAnimFrameMonitor,
  CreateAudioAnimFrameMonitor = CreateAudioAnimFrameMonitor,
  CreateHealthMonitor = CreateHealthMonitor,
  CreateDeathMonitor = CreateDeathMonitor,
  CreateInteractButtonMonitor = CreateInteractButtonMonitor,
  CreateEvadeButtonMonitor = CreateEvadeButtonMonitor,
  CreateSquareButtonMonitor = CreateSquareButtonMonitor,
  CreateTriangleButtonMonitor = CreateTriangleButtonMonitor,
  CreateCircleButtonMonitor = CreateCircleButtonMonitor,
  CreateCrossButtonMonitor = CreateCrossButtonMonitor,
  CreateLeftButtonMonitor = CreateLeftButtonMonitor,
  CreateRightButtonMonitor = CreateRightButtonMonitor,
  CreateUpButtonMonitor = CreateUpButtonMonitor,
  CreateDownButtonMonitor = CreateDownButtonMonitor,
  CreateL1ButtonMonitor = CreateL1ButtonMonitor,
  CreateR1ButtonMonitor = CreateR1ButtonMonitor,
  CreateL2ButtonMonitor = CreateL2ButtonMonitor,
  CreateR2ButtonMonitor = CreateR2ButtonMonitor,
  CreateL3ButtonMonitor = CreateL3ButtonMonitor,
  CreateR3ButtonMonitor = CreateR3ButtonMonitor,
  CreateStartButtonMonitor = CreateStartButtonMonitor,
  CreateSelectButtonMonitor = CreateSelectButtonMonitor
})
