local thunk = require("core.thunk")
local timerlib = require("core.timer")
local runlistlib = require("core.runlist")
local runList = runlistlib.RunList.New()
thunk.Install("OnUpdate", function(lvl)
  runList:Update(lvl:GetUnitTime())
end)
function _G.StartLevelTimer(period, callback, ...)
  local T = timerlib.Timer.New(runList, period, callback, ...)
  T:Start()
  return T
end
return {
  StartLevelTimer = _G.StartLevelTimer
}
