local thunk = require("core.thunk")
local MPIconCallback = function(go, action, iconName, arg2)
  game.UI.HandleMPIconEvent(go, action, iconName, arg2)
end
local MPIconLevelCallback = function(_, go, action, iconName, arg2)
  game.UI.HandleMPIconEvent(go, action, iconName, arg2)
end
local MPIconAnimCallback = function(_, go, iconName, style, animName, animRate, startTime, endTime, seekDuration)
  game.UI.PlayMPIconAnim(go, iconName, style, animName, animRate, startTime, endTime, seekDuration)
end
local MPIconSetTextCallback = function(_, go, iconName, textObjectName, text)
  game.UI.SetMPIconText(go, iconName, textObjectName, text)
end
local MPIconMaterialSwapCallback = function(_, go, iconName, materialSwapName)
  if game.UI.SetMPIconMaterialSwap ~= nil then
    game.UI.SetMPIconMaterialSwap(go, iconName, materialSwapName)
  end
end
thunk.Install("__OnMPIconCallback", MPIconCallback)
thunk.Install("__OnMPIconLevelCallback", MPIconLevelCallback)
thunk.Install("__OnPlayMPIconAnim", MPIconAnimCallback)
thunk.Install("__OnSetMPIconText", MPIconSetTextCallback)
thunk.Install("__OnSetMPIconMaterialSwap", MPIconMaterialSwapCallback)
local Create = function(iconName, jointName)
  engine.SerializeHook("__OnMPIconCallback", "MP_ICON_TWEAK", iconName, jointName)
end
local Show = function(iconName)
  engine.SerializeHook("__OnMPIconCallback", "MP_ICON_VIS_ON", iconName)
end
local Hide = function(iconName)
  engine.SerializeHook("__OnMPIconCallback", "MP_ICON_VIS_OFF", iconName)
end
local Off = function(iconName)
  engine.SerializeHook("__OnMPIconCallback", "MP_ICON_OFF", iconName)
end
local Parent = function(iconName, parentName)
  engine.SerializeHook("__OnMPIconCallback", "MP_ICON_PARENT", iconName, parentName)
end
local level = {
  Create = function(go, iconName, jointName)
    engine.SerializeHook("__OnMPIconLevelCallback", go, "MP_ICON_TWEAK", iconName, jointName)
  end,
  Show = function(go, iconName)
    engine.SerializeHook("__OnMPIconLevelCallback", go, "MP_ICON_VIS_ON", iconName)
  end,
  Hide = function(go, iconName)
    engine.SerializeHook("__OnMPIconLevelCallback", go, "MP_ICON_VIS_OFF", iconName)
  end,
  Off = function(go, iconName)
    engine.SerializeHook("__OnMPIconLevelCallback", go, "MP_ICON_OFF", iconName)
  end,
  Parent = function(go, iconName, parentName)
    engine.SerializeHook("__OnMPIconLevelCallback", go, "MP_ICON_PARENT", iconName, parentName)
  end,
  PlayAnimation = function(go, iconName, style, animName, animRate, startTime, endTime, seekDuration)
    engine.SerializeHook("__OnPlayMPIconAnim", go, iconName, style, animName, animRate, startTime, endTime, seekDuration)
  end,
  FadeIn = function(go, iconName, jointName)
    engine.SerializeHook("__OnMPIconLevelCallback", go, "MP_ICON_FADE_IN", iconName, jointName)
  end,
  FadeOut = function(go, iconName, jointName)
    engine.SerializeHook("__OnMPIconLevelCallback", go, "MP_ICON_FADE_OUT", iconName, jointName)
  end,
  SetTextObjectText = function(go, iconName, textObjectName, text)
    engine.SerializeHook("__OnSetMPIconText", go, iconName, textObjectName, text)
  end,
  SetMaterialSwap = function(go, iconName, materialSwapName)
    engine.SerializeHook("__OnSetMPIconMaterialSwap", go, iconName, materialSwapName)
  end
}
return {
  Create = Create,
  Show = Show,
  Hide = Hide,
  Off = Off,
  Parent = Parent,
  level = level
}
