local SendEventToUI = function(eventName, ...)
  engine.SendHook("UI_CALL_EVENT", engine.GetUIWad(), eventName, ...)
end
local UI_Event_SetAutomationPrintoutsEnabled = function(enable)
  SendEventToUI("EVT_ENABLE_AUTOMATION_PRINTOUTS", enable)
end
local UI_Event_SendMsgToJournalLog = function(args)
  SendEventToUI("EVT_SEND_MSG_TO_JOURNAL_LOG", args)
end
local UI_Event_SendMsgToQuestLog = function(args)
  SendEventToUI("EVT_SEND_MSG_TO_QUEST_LOG", args)
end
local UI_Event_SendMsgToResourceLog = function(args)
  SendEventToUI("EVT_SEND_MSG_TO_RESOURCE_LOG", args)
end
local UI_Event_DiscoverLocation = function(text, timer)
  SendEventToUI("EVT_QUEUE_DISCOVER_LOCATION", {text = text, timer = timer})
end
local UI_Internal_SendDesignerMessage = function(argTable)
  SendEventToUI("EVT_TEXT_DESIGNER_MESSAGE", argTable)
end
local msgParam = {
  ADVANCE_PRESS = -1,
  ADVANCE_TAP = -1,
  ADVANCE_HOLD = -2,
  INFINITE_TIMER = 0,
  ADVANCE_TIMER = 1,
  ADVANCE_PRESS_NOPAUSE = -3,
  ADVANCE_PRESS_FORCEPAUSE = -4,
  MESSAGE_STANDARD = 1,
  MESSAGE_TUTORIAL = 2,
  MESSAGE_ITEM_CARD = 3,
  MESSAGE_SIDEBAR = 4,
  MESSAGE_SPLASHSCREEN = 5,
  MESSAGE_BOTTOM = 6,
  VARIANTS_BEGIN = 100,
  SIDEBAR_SMALL = 4,
  SIDEBAR_MEDIUM = 100,
  SIDEBAR_LARGE = 101,
  SPLASHSCREEN_LANDSCAPE_SMALL = 5,
  SPLASHSCREEN_LANDSCAPE_LARGE = 103,
  SPLASHSCREEN_PORTRAIT_SMALL = 104,
  SPLASHSCREEN_PORTRAIT_LARGE = 105,
  SPLASHSCREEN_NO_IMAGE = 106,
  PAUSE_TUTORIAL_SMALL = 2,
  PAUSE_TUTORIAL_LARGE = 200,
  OPTIONS_SETTINGS = "SETTINGS",
  OPTIONS_MENU = "MENU",
  OPTIONS_WEAPON = "WEAPON",
  OPTIONS_SKILL_TREE = "SKILL_TREE",
  OPTIONS_STATS = "STATS",
  OPTIONS_MAP = "MAP",
  OPTIONS_QUEST = "QUEST",
  OPTIONS_JOURNAL = "JOURNAL"
}
local SetDesignerMessageAdvanceType = function(argTable, messageParam)
  if messageParam ~= nil then
    if messageParam < msgParam.INFINITE_TIMER then
      argTable.advanceType = messageParam
    elseif messageParam == msgParam.INFINITE_TIMER then
      argTable.advanceType = msgParam.INFINITE_TIMER
      argTable.time = messageParam
    else
      argTable.advanceType = msgParam.ADVANCE_TIMER
      argTable.time = messageParam
    end
  end
end
local MassageDesignerMessage = function(text, argTable)
  argTable.Text = text
  argTable.Title = argTable.tutorialHeaderText
  argTable.MessageType = argTable.messageType
  argTable.AdvanceType = argTable.advanceType
  argTable.EntranceDelay = argTable.messageDelay
  argTable.DisplayTime = argTable.time
  if argTable.ItemCardArgs ~= nil then
    argTable.TypeSpecificData = argTable.ItemCardArgs
  end
end
local UI_Event_SendDesignerMessage = function(text, messageParam, argTable, ...)
  assert(type(text) == "string" or type(text) == "number")
  assert(argTable == nil or type(argTable) == "table")
  if argTable == nil then
    argTable = {}
  end
  SetDesignerMessageAdvanceType(argTable, messageParam)
  argTable.messageType = msgParam.MESSAGE_STANDARD
  local formattedArgs = {
    ...
  }
  if 0 < #formattedArgs then
    argTable.formattedArgs = formattedArgs
  end
  MassageDesignerMessage(text, argTable)
  UI_Internal_SendDesignerMessage(argTable)
end
local UI_Event_ClearAllDesignerMessages = function()
  SendEventToUI("EVT_CLEAR_ALL_DESIGNER_MESSAGES")
end
local UI_Event_TurnOffDesignerMessage = function()
  UI_Event_ClearAllDesignerMessages()
end
local UI_Event_SendTutorialMessage = function(bodyText, messageParam, argTable, ...)
  assert(type(bodyText) == "string" or type(bodyText) == "number")
  assert(argTable == nil or type(argTable) == "table")
  engine.Warning("WARNING: Using old tutorial-style designer message from UI_Event_SendTutorialMessage. Please use a newer format. Please reach out to Sam Sternklar for more information.")
  if argTable == nil then
    argTable = {}
  end
  SetDesignerMessageAdvanceType(argTable, messageParam)
  argTable.messageType = msgParam.MESSAGE_TUTORIAL
  local formattedArgs = {
    ...
  }
  if 0 < #formattedArgs then
    argTable.formattedArgs = formattedArgs
  end
  MassageDesignerMessage(bodyText, argTable)
  UI_Internal_SendDesignerMessage(argTable)
end
local UI_Event_TurnOffTutorialMessage = function()
  UI_Event_ClearAllDesignerMessages()
end
local UI_Event_SendItemCardMessage = function(argTable, itemCardArgTable)
  assert(itemCardArgTable ~= nil and type(itemCardArgTable) == "table")
  if argTable == nil then
    argTable = {}
  end
  SetDesignerMessageAdvanceType(argTable, msgParam.ADVANCE_PRESS)
  argTable.messageType = msgParam.MESSAGE_ITEM_CARD
  argTable.ItemCardArgs = itemCardArgTable
  MassageDesignerMessage("UI_Event_SendItemCardMessage", argTable)
  UI_Internal_SendDesignerMessage(argTable)
end
local UI_Event_TurnOffItemCardMessage = function()
  UI_Event_ClearAllDesignerMessages()
end
local SendGenericDesignerMessage = function(argTable)
  assert(argTable ~= nil and type(argTable) == "table")
  if argTable.AlignTopLeft ~= nil then
    argTable.TextStyle = "NewBaseHeader6_LeftTop"
  end
  if argTable.AlignCenter ~= nil then
    argTable.TextStyle = "NewBaseHeader6"
  end
  if argTable.AdvanceType == msgParam.ADVANCE_TIMER and argTable.DisplayTime ~= nil and argTable.DisplayTime == msgParam.INFINITE_TIMER then
    argTable.AdvanceType = msgParam.INFINITE_TIMER
  end
  UI_Internal_SendDesignerMessage(argTable)
end
local SendStandardDesignerMessage = function(argTable)
  assert(argTable ~= nil and type(argTable) == "table")
  argTable.MessageType = msgParam.MESSAGE_STANDARD
  SendGenericDesignerMessage(argTable)
end
local SendItemCardDesignerMessage = function(argTable)
  assert(argTable ~= nil and type(argTable) == "table")
  argTable.Text = "SendItemCardDesignerMessage"
  argTable.MessageType = msgParam.MESSAGE_ITEM_CARD
  argTable.TypeSpecificData = argTable.ItemCardArgs
  SendGenericDesignerMessage(argTable)
end
local SendBottomDesignerMessage = function(argTable)
  assert(argTable ~= nil and type(argTable) == "table")
  argTable.MessageType = msgParam.MESSAGE_BOTTOM
  SendGenericDesignerMessage(argTable)
end
local SendSplashScreenDesignerMessage = function(argTable)
  assert(argTable ~= nil and type(argTable) == "table")
  argTable.MessageType = msgParam.MESSAGE_SPLASHSCREEN
  if argTable.MessageVariant ~= nil and argTable.MessageVariant >= msgParam.VARIANTS_BEGIN then
    argTable.MessageType = argTable.MessageVariant
  end
  argTable.TypeSpecificData = argTable.ImageMaterialName
  SendGenericDesignerMessage(argTable)
end
local SendSidebarDesignerMessage = function(argTable)
  assert(argTable ~= nil and type(argTable) == "table")
  argTable.MessageType = msgParam.MESSAGE_SIDEBAR
  if argTable.MessageVariant ~= nil and argTable.MessageVariant >= msgParam.VARIANTS_BEGIN then
    argTable.MessageType = argTable.MessageVariant
  end
  SendGenericDesignerMessage(argTable)
end
local UI_Event_SendSubtitleMessage = function(text, timer)
  SendEventToUI("EVT_TEXT_SUBTITLE", text, timer)
end
local UI_Event_TurnOffSubtitleMessage = function()
  SendEventToUI("EVT_TURN_OFF_SUBTITLE")
end
local UI_Event_Setup_Tutorial = function(tutorialName)
  SendEventToUI("EVT_SETUP_TUTORIAL", tutorialName)
end
local UI_Event_Setup_And_Begin_Tutorial = function(tutorialResource, tutorialName)
  SendEventToUI("EVT_SETUP_AND_BEGIN_TUTORIAL", tutorialResource, tutorialName)
end
local UI_Event_ChangeSonMode = function(mode)
  SendEventToUI("EVT_CHANGE_SON_MODE", mode)
end
local UI_Event_Son_Grabbed = function()
  SendEventToUI("EVT_SonGrabStart")
end
local UI_Event_Son_Released_Or_Awakened = function()
  SendEventToUI("EVT_SonGrabEnd")
end
local UI_Event_Son_ShootArrow = function()
  SendEventToUI("EVT_SON_SHOOT_ARROW")
end
local UI_Event_Fade_To_Black = function(timer)
  SendEventToUI("EVT_FADE_OUT", timer)
end
local UI_Event_Fade_In = function(timer)
  SendEventToUI("EVT_FADE_IN", timer)
end
local UI_Event_Turn_Main_HUD_Off = function()
  SendEventToUI("EVT_TURN_MAIN_HUD_OFF")
end
local UI_Event_Turn_Main_HUD_On = function()
  SendEventToUI("EVT_TURN_MAIN_HUD_ON")
end
local UI_Refresh_HUD = function()
  SendEventToUI("EVT_REFRESH_HUD")
end
local UI_Event_Turn_Compass_Off = function()
  SendEventToUI("EVT_UPDATE_COMPASS")
end
local UI_Event_Turn_Compass_On = function()
  SendEventToUI("EVT_UPDATE_COMPASS")
end
local UI_Event_Force_Compass_Off = function()
  SendEventToUI("EVT_UPDATE_COMPASS")
end
local UI_Event_Force_Compass_On = function()
  SendEventToUI("EVT_UPDATE_COMPASS")
end
local UI_Event_Force_Compass_Clear = function()
  SendEventToUI("EVT_UPDATE_COMPASS")
end
local UI_Event_Update_Compass = function()
  SendEventToUI("EVT_UPDATE_COMPASS")
end
local UI_Event_Turn_Reticle_Off = function()
  SendEventToUI("EVT_TURN_RETICLE_OFF")
end
local UI_Event_Turn_Reticle_On = function()
  SendEventToUI("EVT_TURN_RETICLE_ON")
end
local UI_Event_Force_Reticle_Off = function()
  SendEventToUI("EVT_FORCE_RETICLE_OFF")
end
local UI_Event_Force_Reticle_On = function()
  SendEventToUI("EVT_FORCE_RETICLE_ON")
end
local UI_Event_Force_Reticle_Clear = function()
  SendEventToUI("EVT_FORCE_RETICLE_CLEAR")
end
local UI_Event_Turn_Combat_HUD_Off = function()
  SendEventToUI("EVT_COMBAT_HUD_STATE", false)
end
local UI_Event_Turn_Combat_HUD_On = function()
  SendEventToUI("EVT_COMBAT_HUD_STATE", nil)
end
local UI_Event_Force_Combat_HUD_Off = function()
  SendEventToUI("EVT_COMBAT_HUD_STATE", false)
end
local UI_Event_Force_Combat_HUD_On = function()
  SendEventToUI("EVT_COMBAT_HUD_STATE", true)
end
local UI_Event_Force_Combat_HUD_Clear = function()
  SendEventToUI("EVT_COMBAT_HUD_STATE", nil)
end
local UI_Event_Turn_Rage_Meter_Off = function()
  SendEventToUI("EVT_TURN_RAGE_METER_OFF")
end
local UI_Event_Turn_Rage_Meter_On = function()
  SendEventToUI("EVT_TURN_RAGE_METER_ON")
end
local UI_Event_Rage_End = function()
  SendEventToUI("EVT_RAGE_END")
end
local UI_Event_Rage_Start = function()
  SendEventToUI("EVT_RAGE_START")
end
local UI_Event_Rage_Grab = function()
  SendEventToUI("EVT_RAGE_GRAB")
end
local UI_Event_Aim_End = function()
  SendEventToUI("EVT_AIM_END")
end
local UI_Event_Aim_Start = function()
  SendEventToUI("EVT_AIM_START")
end
local UI_Event_Aim_Capable = function()
  SendEventToUI("EVT_AIM_CAPABLE", nil)
end
local UI_Event_Aim_Incapable = function()
  SendEventToUI("EVT_AIM_CAPABLE", false)
end
local UI_Event_Block_End = function()
  SendEventToUI("EVT_BLOCK_END")
end
local UI_Event_Block_Start = function()
  SendEventToUI("EVT_BLOCK_START")
end
local UI_Event_Attack_End = function()
  SendEventToUI("EVT_ATTACK_END")
end
local UI_Event_Attack_Start = function()
  SendEventToUI("EVT_ATTACK_START")
end
local UI_Event_Near_Health_Shard_End = function()
  SendEventToUI("EVT_NEAR_HEALTH_SHARD_END")
end
local UI_Event_Near_Health_Shard_Start = function()
  SendEventToUI("EVT_NEAR_HEALTH_SHARD_START")
end
local UI_Event_Minigame_End = function()
  SendEventToUI("EVT_MINIGAME_END")
end
local UI_Event_Minigame_Start = function()
  SendEventToUI("EVT_MINIGAME_START")
end
local UI_Event_Minigame_Hold_Breath_End = function()
  SendEventToUI("EVT_MINIGAME_HOLD_BREATH_END")
end
local UI_Event_Minigame_Hold_Breath_Start = function()
  SendEventToUI("EVT_MINIGAME_HOLD_BREATH_START")
end
local UI_Event_Minigame_Hold_Breath = function(amount)
  SendEventToUI("EVT_MINIGAME_HOLD_BREATH", amount)
end
local UI_Event_Minigame_Hold_Breath_Invalid_Target = function()
  SendEventToUI("EVT_MINIGAME_HOLD_BREATH_INVALID_TARGET")
end
local UI_Event_Minigame_Hold_Breath_Valid_Target = function()
  SendEventToUI("EVT_MINIGAME_HOLD_BREATH_VALID_TARGET")
end
local UI_Event_Open_Vendor_Menu = function(vendorWallet, bothHuldraAvailable)
  SendEventToUI("EVT_OPEN_VENDOR_MENU", vendorWallet, bothHuldraAvailable)
end
local UI_Event_Close_Vendor_Menu = function()
  SendEventToUI("EVT_TURN_OFF_GLOBAL_MENU")
end
local UI_Event_Hide_Attribute_Descriptions = function()
  SendEventToUI("EVT_HIDE_ATTRIBUTE_DESCRIPTIONS")
end
local UI_Event_SetExitAllowed = function()
  SendEventToUI("EVT_SET_EXIT_ALLOWED")
end
local UI_Event_SetExitNotAllowed = function()
  SendEventToUI("EVT_SET_EXIT_NOT_ALLOWED")
end
local UI_Event_Open_Realm_Table_Menu = function(selectedRealmInfo)
  SendEventToUI("EVT_OPEN_REALM_TABLE_MENU", selectedRealmInfo)
end
local UI_Event_Close_Realm_Table_Menu = function()
  SendEventToUI("EVT_TURN_OFF_GLOBAL_MENU")
end
local UI_Event_Update_Realm_Table_Menu = function(selectedRealmInfo)
  SendEventToUI("EVT_UPDATE_REALM_TABLE_MENU", selectedRealmInfo)
end
local UI_Close_Pause_Menu = function()
  SendEventToUI("EVT_CLOSE_PAUSE_MENU")
end
local UI_Event_Open_Weapon_Menu = function(weaponName, pickupSlotName, pickupName)
  SendEventToUI("EVT_GO_TO_WEAPON", weaponName, pickupSlotName, pickupName)
end
local UI_Event_Open_Stats_Menu = function(pickupSlotName, pickupName)
  SendEventToUI("EVT_GO_TO_STATS", pickupSlotName, pickupName)
end
local UI_Event_Open_Map_Menu_FastTravel = function(realmName, fastTravelIdBeingOpenedFrom)
  assert(fastTravelIdBeingOpenedFrom ~= nil, "UI_Event_Open_Map_Menu_FastTravel called without a fast travel marker id!")
  SendEventToUI("EVT_GO_TO_MAP", realmName, fastTravelIdBeingOpenedFrom, true)
end
local UI_Event_Open_Map_Menu = function(realmName)
  SendEventToUI("EVT_GO_TO_MAP", realmName)
end
local UI_Event_Open_Quests_Menu = function(questID)
  SendEventToUI("EVT_GO_TO_QUEST", questID)
end
local UI_Event_Go_To_Settings = function(...)
  SendEventToUI("EVT_GO_TO_SETTINGS", ...)
end
local UI_Disable_Pause_Menu = function()
  SendEventToUI("EVT_DISABLE_PAUSE_MENU")
end
local UI_Enable_Pause_Menu = function()
  SendEventToUI("EVT_ENABLE_PAUSE_MENU")
end
local UI_Global_Menu_Set_Exclusive_Access = function(menuName)
  SendEventToUI("EVT_GLOBAL_MENU_SET_EXCLUSIVE_ACCESS", menuName)
end
local UI_Global_Menu_Request_Exclusive_Access = function(menuName, requestScript)
  SendEventToUI("EVT_GLOBAL_MENU_REQUEST_EXCLUSIVE_ACCESS", menuName, requestScript)
end
local UI_Global_Menu_Clear_Exclusive_Access = function(menuName)
  SendEventToUI("EVT_GLOBAL_MENU_CLEAR_EXCLUSIVE_ACCESS", menuName)
end
local UI_Journal_Log_Pause = function()
  SendEventToUI("EVT_Journal_Log_Pause")
end
local UI_Journal_Log_Unpause = function()
  SendEventToUI("EVT_Journal_Log_Unpause")
end
local UI_Event_Queue_Death_Tip = function(lamsID)
  local EVT_QUEUE_DEATH_TIPS = 900
  game.UI.SendEvent("*", EVT_QUEUE_DEATH_TIPS, lamsID)
end
local UI_Event_Unqueue_Death_Tip = function(lamsID)
  local EVT_UNQUEUE_DEATH_TIPS = 901
  if lamsID == nil then
    lamsID = -1
  end
  game.UI.SendEvent("*", EVT_UNQUEUE_DEATH_TIPS, lamsID)
end
local EnableMechanicMeter = function(meterName, meterIsPurple)
  SendEventToUI("EVT_MECHANIC_METER", meterName, meterIsPurple)
end
local EnableMechanicText = function(text, formattedArgs)
  SendEventToUI("EVT_MECHANIC_TEXT", text, formattedArgs)
end
local EnableMechanicRage = function(displayTime)
  SendEventToUI("EVT_MECHANIC_RAGE", displayTime)
end
local EnableMechanicNonRage = function(displayTime)
  SendEventToUI("EVT_MECHANIC_NONRAGE", displayTime)
end
local DisableMechanicText = function()
  SendEventToUI("EVT_DISABLE_MECHANIC_TEXT")
end
local DisableMechanicMeter = function()
  SendEventToUI("EVT_DISABLE_MECHANIC_METER")
end
local DisableMechanicRage = function()
  SendEventToUI("EVT_DISABLE_MECHANIC_RAGE")
end
local DisableMechanicNonRage = function()
  SendEventToUI("EVT_DISABLE_MECHANIC_NONRAGE")
end
local DisableAllMechanics = function()
  SendEventToUI("EVT_DISABLE_MECHANIC")
end
local UI_Event_PlaygoDownloading = function(playgo, obj)
  SendEventToUI("EVT_IN_GAME_PLAYGO_PROGESS", playgo, obj)
end
local UI_Event_Turn_off_PlaygoDownloading = function()
  SendEventToUI("EVT_IN_GAME_TURNOFF_PLAYGO_PROGRESS")
end
return {
  UI_Event_SetAutomationPrintoutsEnabled = UI_Event_SetAutomationPrintoutsEnabled,
  UI_Event_SendMsgToJournalLog = UI_Event_SendMsgToJournalLog,
  UI_Event_SendMsgToQuestLog = UI_Event_SendMsgToQuestLog,
  UI_Event_SendMsgToResourceLog = UI_Event_SendMsgToResourceLog,
  UI_Event_DiscoverLocation = UI_Event_DiscoverLocation,
  msgParam = msgParam,
  UI_Event_SendDesignerMessage = UI_Event_SendDesignerMessage,
  UI_Event_TurnOffDesignerMessage = UI_Event_TurnOffDesignerMessage,
  UI_Event_ClearAllDesignerMessages = UI_Event_ClearAllDesignerMessages,
  UI_Event_SendPlaytestFullscreenMessage = function()
  end,
  SendStandardDesignerMessage = SendStandardDesignerMessage,
  SendItemCardDesignerMessage = SendItemCardDesignerMessage,
  SendBottomDesignerMessage = SendBottomDesignerMessage,
  SendSplashScreenDesignerMessage = SendSplashScreenDesignerMessage,
  SendSidebarDesignerMessage = SendSidebarDesignerMessage,
  UI_Event_SendTutorialMessage = UI_Event_SendTutorialMessage,
  UI_Event_TurnOffTutorialMessage = UI_Event_TurnOffTutorialMessage,
  UI_Event_SendItemCardMessage = UI_Event_SendItemCardMessage,
  UI_Event_TurnOffItemCardMessage = UI_Event_TurnOffItemCardMessage,
  UI_Event_Setup_Tutorial = UI_Event_Setup_Tutorial,
  UI_Event_Setup_And_Begin_Tutorial = UI_Event_Setup_And_Begin_Tutorial,
  UI_Event_SendSubtitleMessage = UI_Event_SendSubtitleMessage,
  UI_Event_TurnOffSubtitleMessage = UI_Event_TurnOffSubtitleMessage,
  UI_Event_ChangeSonMode = UI_Event_ChangeSonMode,
  UI_Event_Son_ShootArrow = UI_Event_Son_ShootArrow,
  UI_Event_Son_Grabbed = UI_Event_Son_Grabbed,
  UI_Event_Son_Released_Or_Awakened = UI_Event_Son_Released_Or_Awakened,
  UI_Event_Fade_To_Black = UI_Event_Fade_To_Black,
  UI_Event_Fade_In = UI_Event_Fade_In,
  UI_Event_Turn_Main_HUD_Off = UI_Event_Turn_Main_HUD_Off,
  UI_Event_Turn_Main_HUD_On = UI_Event_Turn_Main_HUD_On,
  UI_Refresh_HUD = UI_Refresh_HUD,
  UI_Event_Turn_Compass_Off = UI_Event_Turn_Compass_Off,
  UI_Event_Turn_Compass_On = UI_Event_Turn_Compass_On,
  UI_Event_Force_Compass_Off = UI_Event_Force_Compass_Off,
  UI_Event_Force_Compass_On = UI_Event_Force_Compass_On,
  UI_Event_Force_Compass_Clear = UI_Event_Force_Compass_Clear,
  UI_Event_Update_Compass = UI_Event_Update_Compass,
  UI_Event_Turn_Reticle_Off = UI_Event_Turn_Reticle_Off,
  UI_Event_Turn_Reticle_On = UI_Event_Turn_Reticle_On,
  UI_Event_Force_Reticle_Off = UI_Event_Force_Reticle_Off,
  UI_Event_Force_Reticle_On = UI_Event_Force_Reticle_On,
  UI_Event_Force_Reticle_Clear = UI_Event_Force_Reticle_Clear,
  UI_Event_Turn_Combat_HUD_Off = UI_Event_Turn_Combat_HUD_Off,
  UI_Event_Turn_Combat_HUD_On = UI_Event_Turn_Combat_HUD_On,
  UI_Event_Force_Combat_HUD_Off = UI_Event_Force_Combat_HUD_Off,
  UI_Event_Force_Combat_HUD_On = UI_Event_Force_Combat_HUD_On,
  UI_Event_Force_Combat_HUD_Clear = UI_Event_Force_Combat_HUD_Clear,
  UI_Event_Turn_Rage_Meter_Off = UI_Event_Turn_Rage_Meter_Off,
  UI_Event_Turn_Rage_Meter_On = UI_Event_Turn_Rage_Meter_On,
  UI_Event_Rage_End = UI_Event_Rage_End,
  UI_Event_Rage_Start = UI_Event_Rage_Start,
  UI_Event_Rage_Grab = UI_Event_Rage_Grab,
  UI_Event_Aim_End = UI_Event_Aim_End,
  UI_Event_Aim_Start = UI_Event_Aim_Start,
  UI_Event_Aim_Capable = UI_Event_Aim_Capable,
  UI_Event_Aim_Incapable = UI_Event_Aim_Incapable,
  UI_Event_Block_End = UI_Event_Block_End,
  UI_Event_Block_Start = UI_Event_Block_Start,
  UI_Event_Attack_End = UI_Event_Attack_End,
  UI_Event_Attack_Start = UI_Event_Attack_Start,
  UI_Event_Near_Health_Shard_End = UI_Event_Near_Health_Shard_End,
  UI_Event_Near_Health_Shard_Start = UI_Event_Near_Health_Shard_Start,
  UI_Event_Minigame_End = UI_Event_Minigame_End,
  UI_Event_Minigame_Start = UI_Event_Minigame_Start,
  UI_Event_Minigame_Hold_Breath_End = UI_Event_Minigame_Hold_Breath_End,
  UI_Event_Minigame_Hold_Breath_Start = UI_Event_Minigame_Hold_Breath_Start,
  UI_Event_Minigame_Hold_Breath = UI_Event_Minigame_Hold_Breath,
  UI_Event_Minigame_Hold_Breath_Invalid_Target = UI_Event_Minigame_Hold_Breath_Invalid_Target,
  UI_Event_Minigame_Hold_Breath_Valid_Target = UI_Event_Minigame_Hold_Breath_Valid_Target,
  UI_Event_Open_Vendor_Menu = UI_Event_Open_Vendor_Menu,
  UI_Event_Close_Vendor_Menu = UI_Event_Close_Vendor_Menu,
  UI_Event_Hide_Attribute_Descriptions = UI_Event_Hide_Attribute_Descriptions,
  UI_Event_SetExitAllowed = UI_Event_SetExitAllowed,
  UI_Event_SetExitNotAllowed = UI_Event_SetExitNotAllowed,
  UI_Event_Open_Realm_Table_Menu = UI_Event_Open_Realm_Table_Menu,
  UI_Event_Close_Realm_Table_Menu = UI_Event_Close_Realm_Table_Menu,
  UI_Event_Update_Realm_Table_Menu = UI_Event_Update_Realm_Table_Menu,
  UI_Close_Pause_Menu = UI_Close_Pause_Menu,
  UI_Event_Open_Weapon_Menu = UI_Event_Open_Weapon_Menu,
  UI_Event_Open_Stats_Menu = UI_Event_Open_Stats_Menu,
  UI_Event_Open_Map_Menu = UI_Event_Open_Map_Menu,
  UI_Event_Open_Map_Menu_FastTravel = UI_Event_Open_Map_Menu_FastTravel,
  UI_Event_Open_Quests_Menu = UI_Event_Open_Quests_Menu,
  UI_Event_Go_To_Settings = UI_Event_Go_To_Settings,
  UI_Disable_Pause_Menu = UI_Disable_Pause_Menu,
  UI_Enable_Pause_Menu = UI_Enable_Pause_Menu,
  UI_Global_Menu_Set_Exclusive_Access = UI_Global_Menu_Set_Exclusive_Access,
  UI_Global_Menu_Request_Exclusive_Access = UI_Global_Menu_Request_Exclusive_Access,
  UI_Global_Menu_Clear_Exclusive_Access = UI_Global_Menu_Clear_Exclusive_Access,
  UI_Event_Queue_Death_Tip = UI_Event_Queue_Death_Tip,
  UI_Event_Unqueue_Death_Tip = UI_Event_Unqueue_Death_Tip,
  DisableAllMechanics = DisableAllMechanics,
  EnableMechanicText = EnableMechanicText,
  UpdateMechanicText = EnableMechanicText,
  DisableMechanicText = DisableMechanicText,
  EnableMechanicMeter = EnableMechanicMeter,
  DisableMechanicMeter = DisableMechanicMeter,
  EnableMechanicRage = EnableMechanicRage,
  DisableMechanicRage = DisableMechanicRage,
  EnableMechanicNonRage = EnableMechanicNonRage,
  DisableMechanicNonRage = DisableMechanicNonRage,
  UI_Event_PlaygoDownloading = UI_Event_PlaygoDownloading,
  UI_Event_Turn_off_PlaygoDownloading = UI_Event_Turn_off_PlaygoDownloading,
  UI_Journal_Log_Pause = UI_Journal_Log_Pause,
  UI_Journal_Log_Unpause = UI_Journal_Log_Unpause
}
