local LookAtUtil = require("game.lookAtUtil")
local Priority = LookAtUtil.Priority
LookAtUtil.SetLookAtTargetTypes({
  CombatTarget = Priority.Highest,
  Attacker = Priority.High,
  Hero = Priority.High,
  Kid = Priority.High,
  FriendlyAI = Priority.High,
  InterestingObject = Priority.Medium,
  Pathing = Priority.Highest,
  BadGuy = Priority.Ignore
})
LookAtUtil.SetLookAtStaticValues({
  DiffPerPriority = 5,
  MaxLookAtDistance = 300,
  IdleLookAtTimer = 2,
  ReengageAngle = 40,
  DisengageScreenPercent = 0.8,
  ExtraMaxAngleForCamera = 70,
  DetectionSquareShrinkSpeed = 1,
  CombatTargetName = "CombatTarget"
})
local TargetType = LookAtUtil.GetTargetTypeTable()
return {
  Priority = Priority,
  RegisterDuringUIStartup = LookAtUtil.Register,
  TargetType = TargetType
}
