local Priority = {
  Highest = 0,
  High = 1,
  Medium = 2,
  Low = 3,
  Lowest = 4,
  Ignore = 5
}
local masterTable, staticValueTable, targetTypeTable
local Register = function()
  if game.SetLookAtStaticInfo then
    local unusedArg = 0
    game.SetLookAtStaticInfo(masterTable, unusedArg, unusedArg, staticValueTable)
  end
end
local SetLookAtTargetTypes = function(table)
  masterTable = table
  targetTypeTable = {}
  for typeName, _ in pairs(masterTable) do
    targetTypeTable[typeName] = engine.Hash(typeName)
  end
end
local SetLookAtStaticValues = function(table)
  staticValueTable = table
end
local GetTargetTypeTable = function()
  return targetTypeTable
end
return {
  Register = Register,
  Priority = Priority,
  SetLookAtTargetTypes = SetLookAtTargetTypes,
  SetLookAtStaticValues = SetLookAtStaticValues,
  GetTargetTypeTable = GetTargetTypeTable
}
