local profile = require("core.profile")
local Variants = {
  "D_CREATURE_SILVER",
  "C_CREATURE_SILVER",
  "B_CREATURE_SILVER",
  "C_CREATURE_RIVERPASS",
  "B_CREATURE_RIVERPASS",
  "C_CREATURE_ALFHEIM",
  "B_CREATURE_ALFHEIM",
  "C_CREATURE_PEAKSPASS",
  "B_CREATURE_PEAKSPASS",
  "C_CREATURE_HELHEIM",
  "B_CREATURE_HELHEIM",
  "C_CREATURE_TEMPLE",
  "B_CREATURE_TEMPLE",
  "B_CREATURE_REINFORCEMENT1",
  "B_CREATURE_REINFORCEMENT2",
  "B_CREATURE_REINFORCEMENT3",
  "B_CREATURE_REINFORCEMENT4",
  "B_CREATURE_REINFORCEMENT5",
  "COMMON_RUNE",
  "RARE_RUNE_DEFENSIVE",
  "LEGENDARY_RUNE_DEFENSIVE",
  "EPIC_RUNE_DEFENSIVE",
  "RARE_RUNE_ON_KILL",
  "LEGENDARY_RUNE_ON_KILL",
  "EPIC_RUNE_ON_KILL",
  "RARE_RUNE_LOW_HEALTH",
  "LEGENDARY_RUNE_LOW_HEALTH",
  "EPIC_RUNE_LOW_HEALTH",
  "RARE_RUNE_TAKE_DAMAGE",
  "LEGENDARY_RUNE_TAKE_DAMAGE",
  "EPIC_RUNE_TAKE_DAMAGE",
  "RARE_RUNE_CLEAVE",
  "LEGENDARY_RUNE_CLEAVE",
  "EPIC_RUNE_CLEAVE",
  "RARE_RUNE_STATS",
  "LEGENDARY_RUNE_STATS",
  "TRAVELER_DROP",
  "ENHANCED_TRAVELER_DROP",
  "GOLEM_DROP",
  "ENHANCED_GOLEM_DROP",
  "VAULT_BOSS_REWARD",
  "RIVER_PASS_TROLL_REWARD",
  "FOOTHILLS_JOTUNN_REWARD",
  "ALFHEIM_BOSS_REWARD",
  "ALFHEIM_GOLEM_REWARD",
  "ALFHEIM_BOSS_ENCHANTMENT_REWARD",
  "PEAKS_TROLL_REWARD",
  "STONEMASON_GOLEM_REWARD",
  "STONEMASON_TROLL_REWARD",
  "HELONE_TRAVELER_REWARD",
  "PEAKSTWO_GOLEM_REWARD",
  "REALM_TROLL_REWARD",
  "FOOTHILLS_VALKYRIE_REWARD",
  "STONEMASON_VALKYRIE_REWARD",
  "PEAKS_VALKYRIE_REWARD",
  "RIVER_VALKYRIE_REWARD",
  "HEL_VALKYRIE_REWARD",
  "ALF_VALKYRIE_REWARD",
  "MUSP_VALKYRIE_REWARD",
  "NIFL_VALKYRIE_REWARD",
  "QUEEN_VALK_REWARD",
  "CALSHORE_TROLL_REWARD",
  "VIKING_TROLL_REWARD",
  "STRONGHOLD_TRAVELER_REWARD",
  "MINES_ELITE_REWARD",
  "HTTK_TRAVELER_REWARD",
  "MINE_SOULEATER_REWARD",
  "VIKING_GOLEM_REWARD",
  "SHIPWRECK_GOLEM_REWARD",
  "VIKING_TROLL_KEY_REWARD",
  "FORDGN_GOLEM_REWARD",
  "RUINS_GOLEM_REWARD",
  "HTTK_GOLEM_REWARD",
  "FOOTHILLS_VALKYRIE_RESOURCE",
  "STONEMASON_VALKYRIE_RUNE",
  "STONEMASON_VALKYRIE_RESOURCES",
  "PEAKS_VALKYRIE_RUNE",
  "PEAKS_VALKYRIE_RESOURCE",
  "RIVER_VALKYRIE_RUNE",
  "RIVER_VALKYRIE_RESOURCE",
  "HEL_VALKYRIE_RUNE",
  "HEL_VALKYRIE_RESOURCE_S",
  "HEL_VALKYRIE_RESOURCE_L",
  "ALF_VALKYRIE_RUNE",
  "ALF_VALKYRIE_RESOURCE_S",
  "ALF_VALKYRIE_RESOURCE_L",
  "MUSP_VALKYRIE_RUNE",
  "MUSP_VALKYRIE_RESOURCE_S",
  "MUSP_VALKYRIE_RESOURCE_L",
  "NIFL_VALKYRIE_RUNE",
  "NIFL_VALKYRIE_RESOURCE_S",
  "NIFL_VALKYRIE_RESOURCE_L",
  "QUEEN_VALK_RUNE",
  "QUEEN_VALK_RESOURCE_S",
  "QUEEN_VALK_RESOURCE_L",
  "ALFHEIM_BOSS_REINFORCEMENT",
  "PEAKS_TROLL_AXE",
  "FOOTHILLS_JOTUNN_FLAME_REWARD",
  "HELONE_TRAVELER_FLAME_REWARD",
  "MAG_MOD_HACKSILVER",
  "MAG_MOD_RESOURCES",
  "MAG_MOD_LEIPTR",
  "MAG_MOD_FLAME",
  "VAULT_FLAME_REWARD",
  "HELBOSS_FLAME_REWARD",
  "RARE_RUNE_DEFENSIVE_TIER3",
  "RARE_RUNE_DEFENSIVE_TIER4",
  "RARE_RUNE_TAKE_DAMAGE_TIER3",
  "RARE_RUNE_TAKE_DAMAGE_TIER4",
  "TIER7_RUNE",
  "GOLEM_DROP_TRACKED_1",
  "GOLEM_DROP_TRACKED_2",
  "GOLEM_DROP_TRACKED_3",
  "GOLEM_DROP_TRACKED_4",
  "GOLEM_DROP_TRACKED_5",
  "GOLEM_DROP_TRACKED_6",
  "ENHANCED_GOLEM_DROP_TRACKED_1",
  "ENHANCED_GOLEM_DROP_TRACKED_2",
  "ENHANCED_GOLEM_DROP_TRACKED_3",
  "ENHANCED_GOLEM_DROP_TRACKED_4",
  "ENHANCED_GOLEM_DROP_TRACKED_5",
  "ENHANCED_GOLEM_DROP_TRACKED_6",
  "MUSP_VALKYRIE_FLAME",
  "NIFL_VALKYRIE_REWARD_TWO",
  "NIFL_VALKYRIE_RESOURCE_NIF",
  "NIF_RUNE",
  "STN750_RUNIC_REWARD_VARIANT",
  "TRAVELER_DROP_TRACKED_1",
  "TRAVELER_DROP_TRACKED_2",
  "TRAVELER_DROP_TRACKED_3",
  "TRAVELER_DROP_TRACKED_4",
  "TRAVELER_DROP_TRACKED_5",
  "TRAVELER_DROP_TRACKED_6",
  "TRAVELER_DROP_TRACKED_7",
  "TRAVELER_DROP_TRACKED_8",
  "TRAVELER_DROP_TRACKED_9",
  "TRAVELER_DROP_TRACKED_10",
  "ENHANCED_TRAVELER_DROP_TRACKED_1",
  "ENHANCED_TRAVELER_DROP_TRACKED_2",
  "ENHANCED_TRAVELER_DROP_TRACKED_3",
  "ENHANCED_TRAVELER_DROP_TRACKED_4",
  "ENHANCED_TRAVELER_DROP_TRACKED_5",
  "ENHANCED_TRAVELER_DROP_TRACKED_6",
  "ENHANCED_TRAVELER_DROP_TRACKED_7",
  "ENHANCED_TRAVELER_DROP_TRACKED_8",
  "ENHANCED_TRAVELER_DROP_TRACKED_9",
  "ENHANCED_TRAVELER_DROP_TRACKED_10",
  "QUEEN_VALK_REWARD_NGP",
  "MINES_ELITE_NGP_REWARD",
  "STRONGHOLD_TRAVELER_NGP_REWARD",
  "VIKING_TROLL_NGP_REWARD",
  "QUEEN_VALK_RUNE_NGP",
  "PEAKS_VALKYRIE_RUNE_NGP",
  "NIFL_VALKYRIE_NGP_REWARD",
  "NIFL_VALKYRIE_NGP_REWARD_TWO",
  "NIFL_VALKYRIE_RUNE_NGP",
  "MUSP_VALKYRIE_NGP_REWARD",
  "MUSP_VALKYRIE_RUNE_NGP",
  "ALF_VALKYRIE_RUNE_NGP",
  "ALF_VALKYRIE_NGP_REWARD",
  "HEL_VALKYRIE_RUNE_NGP",
  "HEL_VALKYRIE_NGP_REWARD",
  "RIVER_VALKYRIE_RUNE_NGP",
  "RIVER_VALKYRIE_NGP_REWARD",
  "FOOTHILLS_VALKYRIE_NGP_REWARD",
  "STONEMASON_VALKYRIE_RUNE_NGP",
  "PEAKS_VALKYRIE_NGP_REWARD"
}
local RarityTable = {
  D_CREATURE_SILVER = "Common",
  C_CREATURE_SILVER = "Common",
  B_CREATURE_SILVER = "Common",
  C_CREATURE_RIVERPASS = "Rare",
  B_CREATURE_RIVERPASS = "Rare",
  C_CREATURE_ALFHEIM = "Rare",
  B_CREATURE_ALFHEIM = "Rare",
  C_CREATURE_PEAKSPASS = "Rare",
  B_CREATURE_PEAKSPASS = "Rare",
  C_CREATURE_HELHEIM = "Rare",
  B_CREATURE_HELHEIM = "Rare",
  C_CREATURE_TEMPLE = "Rare",
  B_CREATURE_TEMPLE = "Rare",
  B_CREATURE_REINFORCEMENT1 = "Legendary",
  B_CREATURE_REINFORCEMENT2 = "Legendary",
  B_CREATURE_REINFORCEMENT3 = "Legendary",
  B_CREATURE_REINFORCEMENT4 = "Legendary",
  B_CREATURE_REINFORCEMENT5 = "Legendary",
  COMMON_RUNE = "Common",
  RARE_RUNE_ON_KILL = "Rare",
  LEGENDARY_RUNE_ON_KILL = "Legendary",
  EPIC_RUNE_ON_KILL = "Epic",
  RARE_RUNE_LOW_HEALTH = "Rare",
  LEGENDARY_RUNE_LOW_HEALTH = "Legendary",
  EPIC_RUNE_LOW_HEALTH = "Epic",
  RARE_RUNE_TAKE_DAMAGE = "Rare",
  LEGENDARY_RUNE_TAKE_DAMAGE = "Legendary",
  EPIC_RUNE_TAKE_DAMAGE = "Epic",
  RARE_RUNE_CLEAVE = "Rare",
  LEGENDARY_RUNE_CLEAVE = "Legendary",
  EPIC_RUNE_CLEAVE = "Epic",
  LEGENDARY_RUNE_WEAPON_SPECIAL_AXE = "Legendary",
  EPIC_RUNE_WEAPON_SPECIAL_AXE = "Epic",
  VAULT_BOSS_REWARD = "Rare",
  VAULT_FLAME_REWARD = "Legendary",
  RIVER_PASS_TROLL_REWARD = "Rare",
  FOOTHILLS_JOTUNN_REWARD = "Rare",
  ALFHEIM_BOSS_REWARD = "Rare",
  ALFHEIM_GOLEM_REWARD = "Rare",
  ALFHEIM_BOSS_ENCHANTMENT_REWARD = "Rare",
  PEAKS_TROLL_REWARD = "Rare",
  STONEMASON_GOLEM_REWARD = "Rare",
  STONEMASON_TROLL_REWARD = "Rare",
  HELONE_TRAVELER_REWARD = "Rare",
  PEAKSTWO_GOLEM_REWARD = "Legendary",
  REALM_TROLL_REWARD = "Rare",
  FOOTHILLS_VALKYRIE_REWARD = "Epic",
  FOOTHILLS_JOTUNN_FLAME_REWARD = "Legendary",
  HELONE_TRAVELER_FLAME_REWARD = "Legendary",
  HELBOSS_FLAME_REWARD = "Legendary",
  STONEMASON_VALKYRIE_REWARD = "Rare",
  PEAKS_VALKYRIE_REWARD = "Epic",
  RIVER_VALKYRIE_REWARD = "Epic",
  HEL_VALKYRIE_REWARD = "Epic",
  ALF_VALKYRIE_REWARD = "Epic",
  MUSP_VALKYRIE_REWARD = "Epic",
  NIFL_VALKYRIE_REWARD = "Epic",
  QUEEN_VALK_REWARD = "Epic",
  CALSHORE_TROLL_REWARD = "Rare",
  VIKING_TROLL_REWARD = "Rare",
  STRONGHOLD_TRAVELER_REWARD = "Epic",
  MINES_ELITE_REWARD = "Epic",
  HTTK_TRAVELER_REWARD = "Rare",
  MINE_SOULEATER_REWARD = "Rare",
  VIKING_GOLEM_REWARD = "Rare",
  SHIPWRECK_GOLEM_REWARD = "Legendary",
  VIKING_TROLL_KEY_REWARD = "Common",
  FORDGN_GOLEM_REWARD = "Rare",
  RUINS_GOLEM_REWARD = "Rare",
  HTTK_GOLEM_REWARD = "Legendary",
  GOBLIN_COMMON = "Common",
  FOOTHILLS_VALKYRIE_RESOURCE = "Legendary",
  STONEMASON_VALKYRIE_RUNE = "Legendary",
  STONEMASON_VALKYRIE_RESOURCES = "Legendary",
  PEAKS_VALKYRIE_RUNE = "Legendary",
  PEAKS_VALKYRIE_RESOURCE = "Legendary",
  RIVER_VALKYRIE_RUNE = "Legendary",
  RIVER_VALKYRIE_RESOURCE = "Legendary",
  HEL_VALKYRIE_RUNE = "Epic",
  HEL_VALKYRIE_RESOURCE_S = "Legendary",
  HEL_VALKYRIE_RESOURCE_L = "Epic",
  ALF_VALKYRIE_RUNE = "Epic",
  ALF_VALKYRIE_RESOURCE_S = "Legendary",
  ALF_VALKYRIE_RESOURCE_L = "Epic",
  MUSP_VALKYRIE_RUNE = "Epic",
  MUSP_VALKYRIE_RESOURCE_S = "Legendary",
  MUSP_VALKYRIE_RESOURCE_L = "Epic",
  NIFL_VALKYRIE_RUNE = "Epic",
  NIFL_VALKYRIE_RESOURCE_S = "Legendary",
  NIFL_VALKYRIE_RESOURCE_L = "Epic",
  QUEEN_VALK_RUNE = "Epic",
  QUEEN_VALK_RESOURCE_S = "Legendary",
  QUEEN_VALK_RESOURCE_L = "Epic",
  ALFHEIM_BOSS_REINFORCEMENT = "Rare",
  PEAKS_TROLL_AXE = "Legendary",
  MAG_MOD_HACKSILVER = "Common",
  MAG_MOD_RESOURCES = "Rare",
  MAG_MOD_LEIPTR = "Legendary",
  MAG_MOD_FLAME = "Legendary",
  RARE_RUNE_DEFENSIVE_TIER3 = "Rare",
  RARE_RUNE_DEFENSIVE_TIER4 = "Rare",
  RARE_RUNE_TAKE_DAMAGE_TIER3 = "Rare",
  RARE_RUNE_TAKE_DAMAGE_TIER4 = "Rare",
  TIER7_RUNE = "Epic",
  GOLEM_DROP_TRACKED_1 = "Rare",
  GOLEM_DROP_TRACKED_2 = "Rare",
  GOLEM_DROP_TRACKED_3 = "Rare",
  GOLEM_DROP_TRACKED_4 = "Rare",
  GOLEM_DROP_TRACKED_5 = "Rare",
  GOLEM_DROP_TRACKED_6 = "Rare",
  ENHANCED_GOLEM_DROP_TRACKED_1 = "Legendary",
  ENHANCED_GOLEM_DROP_TRACKED_2 = "Legendary",
  ENHANCED_GOLEM_DROP_TRACKED_3 = "Legendary",
  ENHANCED_GOLEM_DROP_TRACKED_4 = "Legendary",
  ENHANCED_GOLEM_DROP_TRACKED_5 = "Legendary",
  ENHANCED_GOLEM_DROP_TRACKED_6 = "Legendary",
  MUSP_VALKYRIE_FLAME = "Legendary",
  NIFL_VALKYRIE_REWARD_TWO = "Epic",
  NIFL_VALKYRIE_RESOURCE_NIF = "Epic",
  NIF_RUNE = "Legendary",
  TRAVELER_DROP_TRACKED_1 = "Rare",
  TRAVELER_DROP_TRACKED_2 = "Rare",
  TRAVELER_DROP_TRACKED_3 = "Rare",
  TRAVELER_DROP_TRACKED_4 = "Rare",
  TRAVELER_DROP_TRACKED_5 = "Rare",
  TRAVELER_DROP_TRACKED_6 = "Rare",
  TRAVELER_DROP_TRACKED_7 = "Rare",
  TRAVELER_DROP_TRACKED_8 = "Rare",
  TRAVELER_DROP_TRACKED_9 = "Rare",
  TRAVELER_DROP_TRACKED_10 = "Rare",
  ENHANCED_TRAVELER_DROP_TRACKED_1 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_2 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_3 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_4 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_5 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_6 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_7 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_8 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_9 = "Epic",
  ENHANCED_TRAVELER_DROP_TRACKED_10 = "Epic",
  QUEEN_VALK_REWARD_NGP = "Epic",
  TRAVELER_DROP = "Rare",
  ENHANCED_TRAVELER_DROP = "Legendary",
  GOLEM_DROP = "Rare",
  ENHANCED_GOLEM_DROP = "Epic",
  MINES_ELITE_NGP_REWARD = "Perfect",
  STRONGHOLD_TRAVELER_NGP_REWARD = "Perfect",
  VIKING_TROLL_NGP_REWARD = "Perfect",
  QUEEN_VALK_RUNE_NGP = "Perfect",
  PEAKS_VALKYRIE_RUNE_NGP = "Perfect",
  NIFL_VALKYRIE_NGP_REWARD = "Perfect",
  NIFL_VALKYRIE_NGP_REWARD_TWO = "Perfect",
  NIFL_VALKYRIE_RUNE_NGP = "Perfect",
  MUSP_VALKYRIE_NGP_REWARD = "Perfect",
  MUSP_VALKYRIE_RUNE_NGP = "Perfect",
  ALF_VALKYRIE_RUNE_NGP = "Perfect",
  ALF_VALKYRIE_NGP_REWARD = "Perfect",
  HEL_VALKYRIE_RUNE_NGP = "Perfect",
  HEL_VALKYRIE_NGP_REWARD = "Perfect",
  RIVER_VALKYRIE_RUNE_NGP = "Perfect",
  RIVER_VALKYRIE_NGP_REWARD = "Perfect",
  FOOTHILLS_VALKYRIE_NGP_REWARD = "Perfect",
  STONEMASON_VALKYRIE_RUNE_NGP = "Perfect",
  PEAKS_VALKYRIE_NGP_REWARD = "Perfect"
}
local LostItemCleanUpTable
LostItemCleanUpTable = {
  VAULT_BOSS_REWARD = {
    Name = "BladeSpecialTripleSlam"
  },
  VAULT_FLAME_REWARD = {
    Name = "BladesReinforcement",
    TrackerResource = "BladesReinforcement_Tracker1",
    NGPRecipe = "Recipe_ChaosFlame_Sellback"
  },
  RIVER_PASS_TROLL_REWARD = {
    Name = "FrostSpecialAxeLeap"
  },
  ALFHEIM_BOSS_REWARD = {
    Name = "SummonFenrir"
  },
  ALFHEIM_GOLEM_REWARD = {
    Name = "RuneCreator_Unique_Alfheim",
    IsRune = true
  },
  PEAKS_TROLL_REWARD = {
    Name = "FrostSpecialAxeRake"
  },
  PEAKS_TROLL_AXE = {
    Name = "AxeReinforcement",
    TrackerResource = "AxeReinforcement_Tracker2",
    NGPRecipe = "Recipe_FrozenFlame_Sellback"
  },
  STONEMASON_GOLEM_REWARD = {
    Name = "RuneCreator_Unique_FrostResist_Defense",
    IsRune = true
  },
  STONEMASON_TROLL_REWARD = {Name = "SummonBoar"},
  HELONE_TRAVELER_REWARD = {
    Name = "WeaponComponent_Blades_OnKill_OffenseBuff",
    Recipe = "Recipe_WeaponComponent_Blades_OnKill_OffenseBuff_Reinforce_1"
  },
  PEAKSTWO_GOLEM_REWARD = {
    Name = "RuneCreator_Unique_FrostResist_Focus",
    IsRune = true
  },
  REALM_TROLL_REWARD = {
    Name = "BladeSpecialCross"
  },
  VIKING_TROLL_REWARD = {
    Name = "Perk_Defense_OnBlock_ActiveAbsorb",
    Recipe = "Recipe_Perk_Defense_OnBlock_ActiveAbsorb_Tier03_Reinforce_1"
  },
  VIKING_TROLL_NGP_REWARD = {
    Name = "Perk_Defense_OnBlock_ActiveAbsorb_NGP",
    Recipe = "Recipe_Perk_Defense_OnBlock_ActiveAbsorb_Tier03_Reinforce_1_NGP"
  },
  FOOTHILLS_VALKYRIE_REWARD = {
    Name = "RuneCreator_Unique_Vanaheim",
    IsRune = true
  },
  FOOTHILLS_VALKYRIE_NGP_REWARD = {
    Name = "RuneCreator_Unique_Vanaheim_NGP",
    IsRune = true
  },
  FOOTHILLS_VALKYRIE_RESOURCE = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker1"
  },
  FOOTHILLS_JOTUNN_FLAME_REWARD = {
    Name = "AxeReinforcement",
    TrackerResource = "AxeReinforcement_Tracker1",
    NGPRecipe = "Recipe_FrozenFlame_Sellback"
  },
  HELONE_TRAVELER_FLAME_REWARD = {
    Name = "BladesReinforcement",
    TrackerResource = "BladesReinforcement_Tracker2",
    NGPRecipe = "Recipe_ChaosFlame_Sellback"
  },
  HELBOSS_FLAME_REWARD = {
    Name = "BladesReinforcement",
    TrackerResource = "BladesReinforcement_Tracker3",
    NGPRecipe = "Recipe_ChaosFlame_Sellback"
  },
  STONEMASON_VALKYRIE_RUNE = {
    Name = "RuneCreator_Unique_Valkyrie04",
    IsRune = true
  },
  STONEMASON_VALKYRIE_RUNE_NGP = {
    Name = "RuneCreator_Unique_Valkyrie04_NGP",
    IsRune = true
  },
  STONEMASON_VALKYRIE_RESOURCES = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker2"
  },
  PEAKS_VALKYRIE_REWARD = {
    Name = "WeaponComponent_Axe_Valkyrie01",
    Recipe = "Recipe_WeaponComponent_Axe_Valkyrie01_Tier05_Reinforce_1"
  },
  PEAKS_VALKYRIE_NGP_REWARD = {
    Name = "WeaponComponent_Axe_Valkyrie01_NGP",
    Recipe = "Recipe_WeaponComponent_Axe_Valkyrie01_Tier05_Reinforce_1_NGP"
  },
  PEAKS_VALKYRIE_RUNE = {
    Name = "RuneCreator_Unique_Valkyrie03",
    IsRune = true
  },
  PEAKS_VALKYRIE_RUNE_NGP = {
    Name = "RuneCreator_Unique_Valkyrie03_NGP",
    IsRune = true
  },
  PEAKS_VALKYRIE_RESOURCE = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker3"
  },
  RIVER_VALKYRIE_REWARD = {
    Name = "KratosArmorTrinket_Valkyrie",
    Recipe = "Recipe_KratosArmorTrinket_Valkyrie_Tier05_Reinforce_1"
  },
  RIVER_VALKYRIE_NGP_REWARD = {
    Name = "KratosArmorTrinket_Valkyrie_NGP",
    Recipe = "Recipe_KratosArmorTrinket_Valkyrie_Tier05_Reinforce_1_NGP"
  },
  RIVER_VALKYRIE_RUNE = {
    Name = "RuneCreator_Unique_Midgard",
    IsRune = true
  },
  RIVER_VALKYRIE_RUNE_NGP = {
    Name = "RuneCreator_Unique_Midgard_NGP",
    IsRune = true
  },
  RIVER_VALKYRIE_RESOURCE = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker4"
  },
  HEL_VALKYRIE_REWARD = {
    Name = "WeaponComponent_Blades_Valkyrie01",
    Recipe = "Recipe_WeaponComponent_Blades_Valkyrie01_Tier05_Reinforce_1"
  },
  HEL_VALKYRIE_NGP_REWARD = {
    Name = "WeaponComponent_Blades_Valkyrie01_NGP",
    Recipe = "Recipe_WeaponComponent_Blades_Valkyrie01_Tier05_Reinforce_1_NGP"
  },
  HEL_VALKYRIE_RUNE = {
    Name = "RuneCreator_Unique_Asgard",
    IsRune = true
  },
  HEL_VALKYRIE_RUNE_NGP = {
    Name = "RuneCreator_Unique_Asgard_NGP",
    IsRune = true
  },
  HEL_VALKYRIE_RESOURCE_S = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker5"
  },
  HEL_VALKYRIE_RESOURCE_L = {
    Name = "PerfectAsgardianSteel",
    TrackerResource = "PerfectAsgardianSteel_Tracker1"
  },
  ALF_VALKYRIE_REWARD = {
    Name = "KratosArmorLegs_ValkyrieSet_Tier06",
    Recipe = "Recipe_KratosArmorLegs_ValkyrieSet_Tier06_Reinforcement_1"
  },
  ALF_VALKYRIE_NGP_REWARD = {
    Name = "KratosArmorLegs_ValkyrieSet_Tier06_NGP",
    Recipe = "Recipe_KratosArmorLegs_ValkyrieSet_Tier06_Reinforcement_1_NGP"
  },
  ALF_VALKYRIE_RUNE = {
    Name = "RuneCreator_Unique_Corruption",
    IsRune = true
  },
  ALF_VALKYRIE_RUNE_NGP = {
    Name = "RuneCreator_Unique_Corruption_NGP",
    IsRune = true
  },
  ALF_VALKYRIE_RESOURCE_S = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker6"
  },
  ALF_VALKYRIE_RESOURCE_L = {
    Name = "PerfectAsgardianSteel",
    TrackerResource = "PerfectAsgardianSteel_Tracker2"
  },
  MUSP_VALKYRIE_REWARD = {
    Name = "KratosArmorWrist_ValkyrieSet_Tier06",
    Recipe = "Recipe_KratosArmorWrist_ValkyrieSet_Tier06_Reinforcement_1"
  },
  MUSP_VALKYRIE_NGP_REWARD = {
    Name = "KratosArmorWrist_ValkyrieSet_Tier06_NGP",
    Recipe = "Recipe_KratosArmorWrist_ValkyrieSet_Tier06_Reinforcement_1_NGP"
  },
  MUSP_VALKYRIE_RUNE = {
    Name = "RuneCreator_Unique_AxeToss03",
    IsRune = true
  },
  MUSP_VALKYRIE_RUNE_NGP = {
    Name = "RuneCreator_Unique_AxeToss03_NGP",
    IsRune = true
  },
  MUSP_VALKYRIE_RESOURCE_S = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker7"
  },
  MUSP_VALKYRIE_RESOURCE_L = {
    Name = "PerfectAsgardianSteel",
    TrackerResource = "PerfectAsgardianSteel_Tracker3"
  },
  NIFL_VALKYRIE_REWARD = {
    Name = "KratosArmorChest_ValkyrieSet_Tier06",
    Recipe = "Recipe_KratosArmorChest_ValkyrieSet_Tier06_Reinforcement_1"
  },
  NIFL_VALKYRIE_NGP_REWARD = {
    Name = "KratosArmorChest_ValkyrieSet_Tier06_NGP",
    Recipe = "Recipe_KratosArmorChest_ValkyrieSet_Tier06_Reinforcement_1_NGP"
  },
  NIFL_VALKYRIE_RUNE = {
    Name = "RuneCreator_Unique_Valkyrie01",
    IsRune = true
  },
  NIFL_VALKYRIE_RUNE_NGP = {
    Name = "RuneCreator_Unique_Valkyrie01_NGP",
    IsRune = true
  },
  NIFL_VALKYRIE_RESOURCE_S = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker8"
  },
  NIFL_VALKYRIE_RESOURCE_L = {
    Name = "PerfectAsgardianSteel",
    TrackerResource = "PerfectAsgardianSteel_Tracker4"
  },
  QUEEN_VALK_REWARD = {
    Name = "WeaponComponent_Axe_QueenValkyrie01",
    Recipe = "Recipe_WeaponComponent_Axe_QueenValkyrie01_Tier05_Reinforce_1"
  },
  QUEEN_VALK_RUNE = {
    Name = "RuneCreator_Unique_Jotunnheim",
    IsRune = true
  },
  QUEEN_VALK_RUNE_NGP = {
    Name = "RuneCreator_Unique_Jotunnheim_NGP",
    IsRune = true
  },
  QUEEN_VALK_RESOURCE_S = {
    Name = "AsgardianSteel",
    TrackerResource = "AsgardianSteel_Tracker9"
  },
  QUEEN_VALK_RESOURCE_L = {
    Name = "PerfectAsgardianSteel",
    TrackerResource = "PerfectAsgardianSteel_Tracker5"
  },
  CALSHORE_TROLL_REWARD = {
    Name = "BladeSpecialFireClap"
  },
  STRONGHOLD_TRAVELER_REWARD = {
    Name = "KratosArmorTrinket_Gauntlet",
    Recipe = "Recipe_KratosArmorTrinket_Gauntlet_Tier03_Reinforce_1"
  },
  STRONGHOLD_TRAVELER_NGP_REWARD = {
    Name = "KratosArmorTrinket_Gauntlet_NGP",
    Recipe = "Recipe_KratosArmorTrinket_Gauntlet_Tier03_Reinforce_1_NGP"
  },
  MINES_ELITE_REWARD = {
    Name = "KratosArmorTrinket_EmpoweringRift",
    Recipe = "Recipe_KratosArmorTrinket_EmpoweringRift_Tier03_Reinforce_1"
  },
  MINES_ELITE_NGP_REWARD = {
    Name = "KratosArmorTrinket_EmpoweringRift_NGP",
    Recipe = "Recipe_KratosArmorTrinket_EmpoweringRift_Tier03_Reinforce_1_NGP"
  },
  HTTK_TRAVELER_REWARD = {
    Name = "WeaponComponent_Blades_OnKill_HealthBurst",
    Recipe = "Recipe_WeaponComponent_Blades_OnKill_HealthBurst_Tier04_Reinforce_1"
  },
  MINE_SOULEATER_REWARD = {
    Name = "RuneCreator_Unique_FireResist_Defense",
    IsRune = true
  },
  VIKING_GOLEM_REWARD = {
    Name = "RuneCreator_Unique_FireResist_Strength",
    IsRune = true
  },
  SHIPWRECK_GOLEM_REWARD = {
    Name = "RuneCreator_Unique_FireResist_Focus",
    IsRune = true
  },
  VIKING_TROLL_KEY_REWARD = {
    Name = "EntryStoneVikingFuneral"
  },
  FORDGN_GOLEM_REWARD = {
    Name = "RuneCreator_Unique_SeidrResist_Resistance",
    IsRune = true
  },
  RUINS_GOLEM_REWARD = {
    Name = "RuneCreator_Unique_SeidrResist_Defense",
    IsRune = true
  },
  HTTK_GOLEM_REWARD = {
    Name = "RuneCreator_Unique_SeidrResist_Runic",
    IsRune = true
  },
  MAG_MOD_LEIPTR = {
    Name = "LeiptrAlloy",
    TrackerResource = "LeiptrAlloy_Tracker"
  },
  MAG_MOD_FLAME = {
    Name = "AxeReinforcement",
    TrackerResource = "AxeReinforcement_Tracker3"
  },
  ALFHEIM_BOSS_ENCHANTMENT_REWARD = {
    Name = "RuneCreator_Unique_AlfheimBoss",
    IsRune = true
  },
  GOLEM_DROP_TRACKED_1 = {
    Name = "GolemLoot",
    TrackerResource = "GolemLoot_Tracker1"
  },
  GOLEM_DROP_TRACKED_2 = {
    Name = "GolemLoot",
    TrackerResource = "GolemLoot_Tracker2"
  },
  GOLEM_DROP_TRACKED_3 = {
    Name = "GolemLoot",
    TrackerResource = "GolemLoot_Tracker3"
  },
  GOLEM_DROP_TRACKED_4 = {
    Name = "GolemLoot",
    TrackerResource = "GolemLoot_Tracker4"
  },
  GOLEM_DROP_TRACKED_5 = {
    Name = "GolemLoot",
    TrackerResource = "GolemLoot_Tracker5"
  },
  GOLEM_DROP_TRACKED_6 = {
    Name = "GolemLoot",
    TrackerResource = "GolemLoot_Tracker6"
  },
  ENHANCED_GOLEM_DROP_TRACKED_1 = {
    Name = "EnhancedGolemLoot",
    TrackerResource = "EnhancedGolemLoot_Tracker1"
  },
  ENHANCED_GOLEM_DROP_TRACKED_2 = {
    Name = "EnhancedGolemLoot",
    TrackerResource = "EnhancedGolemLoot_Tracker2"
  },
  ENHANCED_GOLEM_DROP_TRACKED_3 = {
    Name = "EnhancedGolemLoot",
    TrackerResource = "EnhancedGolemLoot_Tracker3"
  },
  ENHANCED_GOLEM_DROP_TRACKED_4 = {
    Name = "EnhancedGolemLoot",
    TrackerResource = "EnhancedGolemLoot_Tracker4"
  },
  ENHANCED_GOLEM_DROP_TRACKED_5 = {
    Name = "EnhancedGolemLoot",
    TrackerResource = "EnhancedGolemLoot_Tracker5"
  },
  ENHANCED_GOLEM_DROP_TRACKED_6 = {
    Name = "EnhancedGolemLoot",
    TrackerResource = "EnhancedGolemLoot_Tracker6"
  },
  MUSP_VALKYRIE_FLAME = {
    Name = "MuspelheimBladesReinforcement",
    TrackerResource = "BladesReinforcement_Tracker4"
  },
  NIFL_VALKYRIE_REWARD_TWO = {
    Name = "WeaponComponent_Axe_Valkyrie02",
    Recipe = "Recipe_WeaponComponent_Axe_Valkyrie02_Tier05_Reinforce_1"
  },
  NIFL_VALKYRIE_NGP_REWARD_TWO = {
    Name = "WeaponComponent_Axe_Valkyrie02_NGP",
    Recipe = "Recipe_WeaponComponent_Axe_Valkyrie02_Tier05_Reinforce_1_NGP"
  },
  NIFL_VALKYRIE_RESOURCE_NIF = {
    Name = "NiflheimRareLootD"
  },
  TRAVELER_DROP_TRACKED_1 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker1"
  },
  TRAVELER_DROP_TRACKED_2 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker2"
  },
  TRAVELER_DROP_TRACKED_3 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker3"
  },
  TRAVELER_DROP_TRACKED_4 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker4"
  },
  TRAVELER_DROP_TRACKED_5 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker5"
  },
  TRAVELER_DROP_TRACKED_6 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker6"
  },
  TRAVELER_DROP_TRACKED_7 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker7"
  },
  TRAVELER_DROP_TRACKED_8 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker8"
  },
  TRAVELER_DROP_TRACKED_9 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker9"
  },
  TRAVELER_DROP_TRACKED_10 = {
    Name = "TravelerLoot",
    TrackerResource = "TravelerLoot_Tracker10"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_1 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker1"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_2 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker2"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_3 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker3"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_4 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker4"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_5 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker5"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_6 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker6"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_7 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker7"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_8 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker8"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_9 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker9"
  },
  ENHANCED_TRAVELER_DROP_TRACKED_10 = {
    Name = "EnhancedTravelerLoot",
    TrackerResource = "EnhancedTravelerLoot_Tracker10"
  },
  QUEEN_VALK_REWARD_NGP = {
    Name = "WeaponComponent_Axe_QueenValkyrie01_NGP",
    Recipe = "Recipe_WeaponComponent_Axe_QueenValkyrie01_Tier05_Reinforce_1_NGP"
  },
  TRAVELER_DROP = {
    Name = "TravelerLoot",
    IgnoreUniquenessCheck = true
  },
  ENHANCED_TRAVELER_DROP = {
    Name = "EnhancedTravelerLoot",
    IgnoreUniquenessCheck = true
  },
  GOLEM_DROP = {Name = "GolemLoot", IgnoreUniquenessCheck = true},
  ENHANCED_GOLEM_DROP = {
    Name = "EnhancedGolemLoot",
    IgnoreUniquenessCheck = true
  },
  GetName = function(tableName)
    local table = LostItemCleanUpTable[tableName]
    if not table then
      print("WARNING: LostItemCleanupTable " .. tableName .. " does not exist")
      return nil
    end
    if not game.GetNewGamePlus() then
      return table.Name
    end
    local nameExists = table.Name ~= nil
    if table.NaturalNGP and nameExists then
      return table.Name .. "_NGP"
    end
    if table.NGPName then
      return table.NGPName
    end
    if nameExists then
      return table.Name
    end
    print("WARNING: LostItemCleanupTable " .. tableName .. " does not have a name")
    return nil
  end,
  GetRecipe = function(tableName)
    local table = LostItemCleanUpTable[tableName]
    if not table then
      print("WARNING: LostItemCleanupTable " .. tableName .. " does not exist")
      return nil
    end
    if not game.GetNewGamePlus() then
      return table.Recipe
    end
    if table.NaturalNGP and table.Recipe then
      return table.Recipe .. "_NGP"
    end
    if table.NGPRecipe then
      return table.NGPRecipe
    end
    return table.Recipe
  end
}
local EnchantmentDrops = {
  COMMON_RUNE = true,
  RARE_RUNE_DEFENSIVE = true,
  LEGENDARY_RUNE_DEFENSIVE = true,
  EPIC_RUNE_DEFENSIVE = true,
  RARE_RUNE_ON_KILL = true,
  LEGENDARY_RUNE_ON_KILL = true,
  EPIC_RUNE_ON_KILL = true,
  RARE_RUNE_LOW_HEALTH = true,
  LEGENDARY_RUNE_LOW_HEALTH = true,
  EPIC_RUNE_LOW_HEALTH = true,
  RARE_RUNE_TAKE_DAMAGE = true,
  LEGENDARY_RUNE_TAKE_DAMAGE = true,
  EPIC_RUNE_TAKE_DAMAGE = true,
  RARE_RUNE_CLEAVE = true,
  LEGENDARY_RUNE_CLEAVE = true,
  EPIC_RUNE_CLEAVE = true,
  RARE_RUNE_STATS = true,
  LEGENDARY_RUNE_STATS = true,
  FOOTHILLS_JOTUNN_REWARD = true,
  ALFHEIM_GOLEM_REWARD = true,
  STONEMASON_GOLEM_REWARD = true,
  PEAKSTWO_GOLEM_REWARD = true,
  FOOTHILLS_VALKYRIE_REWARD = true,
  STONEMASON_VALKYRIE_RUNE = true,
  PEAKS_VALKYRIE_RUNE = true,
  RIVER_VALKYRIE_RUNE = true,
  HEL_VALKYRIE_RUNE = true,
  ALF_VALKYRIE_RUNE = true,
  NIFL_VALKYRIE_RUNE = true,
  QUEEN_VALK_RUNE = true,
  MINE_SOULEATER_REWARD = true,
  VIKING_GOLEM_REWARD = true,
  SHIPWRECK_GOLEM_REWARD = true,
  FORDGN_GOLEM_REWARD = true,
  RUINS_GOLEM_REWARD = true,
  HTTK_GOLEM_REWARD = true,
  ALFHEIM_BOSS_ENCHANTMENT_REWARD = true,
  NIF_RUNE = true,
  TIER7_RUNE = true,
  QUEEN_VALK_RUNE_NGP = true,
  PEAKS_VALKYRIE_RUNE_NGP = true,
  NIFL_VALKYRIE_RUNE_NGP = true,
  MUSP_VALKYRIE_RUNE_NGP = true,
  ALF_VALKYRIE_RUNE_NGP = true,
  HEL_VALKYRIE_RUNE_NGP = true,
  RIVER_VALKYRIE_RUNE_NGP = true,
  STONEMASON_VALKYRIE_RUNE_NGP = true,
  FOOTHILLS_VALKYRIE_NGP_REWARD = true
}
return profile.WrapLibrary({
  Variants = Variants,
  RarityTable = RarityTable,
  LostItemCleanUpTable = LostItemCleanUpTable,
  EnchantmentDrops = EnchantmentDrops
})
