local cineDock
function ForwardCineCallback(creature, dockObj)
  cineDock = dockObj
end
function LuaHook_TriggerCinematicOverride()
  if cineDock then
    cineDock:CallScript("FireCinematicDockingOverride")
  else
    engine.Warning("No cinematic dock found. The dock/interact may not have forwarded its callback correctly")
  end
  local cineMarker = "pendingDockCinematic"
  RemoveMarker(game.Player.FindPlayer(), cineMarker)
  RemoveMarker(game.AI.FindSon(), cineMarker)
  RemoveMarker(game.Boat.GetPlayerBoat(), cineMarker)
end
function LuaHook_RemovePluckLootMarkers()
  local pluckLootMarker = "preparingToPluckLoot"
  RemoveMarker(game.Player.FindPlayer(), pluckLootMarker)
  RemoveMarker(game.AI.FindSon(), pluckLootMarker)
  RemoveMarker(game.Boat.GetPlayerBoat(), pluckLootMarker)
  local cineMarker = "pendingDockCinematic"
  RemoveMarker(game.Player.FindPlayer(), cineMarker)
  RemoveMarker(game.AI.FindSon(), cineMarker)
  RemoveMarker(game.Boat.GetPlayerBoat(), cineMarker)
end
function RemoveMarker(creature, marker)
  if creature and creature:HasMarker(marker) then
    creature:RemoveMarker(marker)
  end
end
function OnSonSickSequenceOutOfRange()
  game.Audio.PlayBanter("130_SickTurnAround")
end
