LD = require("design.LevelDesignLibrary")
local handles = {}
local pickupCarryBlockMove = "MOV_LiftBlockEnter"
local myGO
function OnScriptLoaded(level, go)
  go:HidePhysics()
  myGO = go
  for i = 1, 4 do
    handles[i] = game.InteractZone.New(go, "handle" .. i)
    handles[i]:SetDebugOffset(0, 0, -2)
  end
end
function OnUpdate(level, go)
end
function OnUseWorld(level, go)
  local count = #handles
  for i = 1, count do
    local interactZone = handles[i]
    if interactZone:PlayerCanInteract() then
      local heroPuppeteer = game.Puppeteer.NewForce(go, "carryBlockHero", game.Player:FindPlayer())
      if heroPuppeteer ~= nil then
        if go.RegisterAsProp ~= nil then
          go:RegisterAsProp("CarryBlock")
        end
        local syncPos = interactZone.containingGameObject:GetWorldJointPosition(interactZone.promptJointIndex)
        local syncDirection = interactZone.containingGameObject:GetWorldJointForward(interactZone.promptJointIndex)
        heroPuppeteer:Align({
          pos = syncPos,
          aligntime = 0.2,
          facing = syncDirection
        })
        heroPuppeteer:StartMove(pickupCarryBlockMove)
        heroPuppeteer:OnComplete(EndPickupCarryBlock)
        return
      end
    end
  end
end
function DisableInteract()
  for i = 1, 4 do
    handles[i]:Disable()
  end
  if myGO.PropDisable ~= nil then
    myGO:PropDisable()
  end
end
function EndPickupCarryBlock(thisPuppeteer)
  if thisPuppeteer ~= nil then
    thisPuppeteer:Clear()
    thisPuppeteer:DetachPuppet()
  end
end
