local thunk = require("core.thunk")
local fsm = require("ui.fsm")
local util = require("ui.util")
local HandleUICallEvent = function(_, eventName, ...)
  fsm.HandleEvent(eventName, ...)
end
local queuedCombatEventPending = false
local combatEventPending = false
local lastInCombatState = false
local SendInCombatEvent = function(...)
  local inCombat = util.IsInCombat()
  if inCombat ~= lastInCombatState then
    local eventName = inCombat and "EVT_EnterCombat" or "EVT_ExitCombat"
    lastInCombatState = inCombat
    fsm.HandleEvent(eventName)
  end
end
local ProcessInCombatEvent = function()
  if combatEventPending then
    SendInCombatEvent()
  end
  combatEventPending = queuedCombatEventPending
  queuedCombatEventPending = false
end
local HandleTargetedStateChange = function(_)
  queuedCombatEventPending = true
end
local ClearCompassMarkersForQuest = function(_, isMainQuest)
  fsm.HandleEvent("EVT_ClearCompassMarkersForQuest", isMainQuest)
end
local ShowCompassMarkerForQuest = function(_, markerNameHash, isMainQuest)
  fsm.HandleEvent("EVT_ShowCompassMarkerForQuest", isMainQuest, markerNameHash)
end
local HideCompassMarkerForQuest = function(_, markerNameHash, isMainQuest)
  fsm.HandleEvent("EVT_HideCompassMarkerForQuest", isMainQuest, markerNameHash)
end
local HandleWithinCompassMarkerRadius = function(_, markerNameHash, isWithinRadius)
  fsm.HandleEvent("EVT_HandleWithinCompassMarkerRadius", markerNameHash, isWithinRadius)
end
local OnPlayerWeaponChanged = function(_, weaponName)
  fsm.HandleEvent("EVT_OnPlayerWeaponChanged", weaponName)
end
local OnPlayerWeaponEvent = function(_, goWeapon, eventName)
  fsm.HandleEvent("EVT_OnPlayerWeaponEvent", goWeapon, eventName)
end
local MapCollisionChangeHook = function(_, collisionGameObjectTable)
  fsm.HandleEvent("EVT_HandleMapCollisionChangeHook", collisionGameObjectTable)
end
local ResourceAmountChange = function(_, args)
  fsm.HandleEvent("EVT_HandleResourceAmountChange", args)
end
local RuneAdded = function(_, args)
  fsm.HandleEvent("EVT_HandleRuneAdded", args)
end
local QuestStateChange = function(_, args)
  fsm.HandleEvent("EVT_HandleQuestStateChange", args)
end
local JournalStateChange = function(_, args)
  fsm.HandleEvent("EVT_HandleJournalStateChange", args)
end
local ResourceInitialized = function(_, args)
  fsm.HandleEvent("EVT_HandleResourceInitialized", args)
end
local UpdateCombatStatus = function(_, args)
  fsm.HandleEvent("EVT_UpdateCombatStatus", args)
end
local PlayerNearHealthRage = function(_, args)
  fsm.HandleEvent("EVT_PlayerNearHealthRage", args)
end
local SonGrabStart = function(_, args)
  fsm.HandleEvent("EVT_SonGrabStart")
end
local SonGrabEnd = function(_, args)
  fsm.HandleEvent("EVT_SonGrabEnd")
end
local CompassAcquire = function(_, args)
  fsm.HandleEvent("EVT_UPDATE_COMPASS", args)
end
local Hook_tActionForceHUDState = function(_, ...)
  fsm.HandleEvent("EVT_tActionForceHUDState", {
    ...
  })
end
local ResDeathStart = function()
  fsm.HandleEvent("EVT_RES_DEATH_START")
end
local ResDeathFail = function()
  fsm.HandleEvent("EVT_RES_DEATH_FAIL")
end
local ResDeathEnd = function()
  fsm.HandleEvent("EVT_RES_DEATH_END")
end
local OnInteractStart = function(_, creature, go)
  fsm.HandleEvent("EVT_OnInteractStart", creature, go)
end
local AllMainQuestAndSummariesCompleted = function()
  if game.QuestManager.CompletionResolved then
    game.QuestManager.CompletionResolved()
    fsm.HandleEvent("EVT_AllMainQuestAndSummariesCompleted")
  end
  if game.CHECK_FEATURE("COMPLETION_ACTIVITYFEED") then
    game.SubmitActivityFeedStory("50_OneHundredPercent")
  end
end
local Install = function()
  thunk.Install("UI_CALL_EVENT", HandleUICallEvent)
  thunk.Install("HandleTargetedStateChange", HandleTargetedStateChange)
  thunk.Install("ClearCompassMarkersForQuest", ClearCompassMarkersForQuest)
  thunk.Install("ShowCompassMarkerForQuest", ShowCompassMarkerForQuest)
  thunk.Install("HideCompassMarkerForQuest", HideCompassMarkerForQuest)
  thunk.Install("HandleWithinCompassMarkerRadius", HandleWithinCompassMarkerRadius)
  thunk.Install("OnPlayerWeaponChanged", OnPlayerWeaponChanged)
  thunk.Install("OnPlayerWeaponEvent", OnPlayerWeaponEvent)
  thunk.Install("MapCollisionChangeHook", MapCollisionChangeHook)
  thunk.Install("ResourceAmountChange", ResourceAmountChange)
  thunk.Install("RuneAdded", RuneAdded)
  thunk.Install("QuestStateChange", QuestStateChange)
  thunk.Install("JournalStateChange", JournalStateChange)
  thunk.Install("ResourceInitialized", ResourceInitialized)
  thunk.Install("UpdateCombatStatus", UpdateCombatStatus)
  thunk.Install("PlayerNearHealthRage", PlayerNearHealthRage)
  thunk.Install("SonGrabStart", SonGrabStart)
  thunk.Install("SonGrabEnd", SonGrabEnd)
  thunk.Install("EVT_COMPASS_ACQUIRED", CompassAcquire)
  thunk.Install("Hook_tActionForceHUDState", Hook_tActionForceHUDState)
  thunk.Install("ResDeathStart", ResDeathStart)
  thunk.Install("ResDeathFail", ResDeathFail)
  thunk.Install("ResDeathEnd", ResDeathEnd)
  thunk.Install("OnInteractStart", OnInteractStart)
  thunk.Install("AllMainQuestAndSummariesCompleted", AllMainQuestAndSummariesCompleted)
end
return {Install = Install, ProcessInCombatEvent = ProcessInCombatEvent}
